/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.portletbridge.test.exception;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.enricher.findby.FindBy;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.portal.api.PortalTest;
import org.jboss.arquillian.portal.api.PortalURL;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.portletbridge.deployment.TestDeployment;
import org.jboss.portletbridge.test.AbstractPortletTest;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.portal.api.PortletArchive;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

import javax.faces.component.UpdateModelException;
import java.net.URL;

import static org.jboss.arquillian.graphene.Graphene.*;
import static org.junit.Assert.assertTrue;

@RunWith(Arquillian.class)
@PortalTest
public class ExceptionWithSuffixTest extends AbstractPortletTest {

    public static final String NEW_VALUE = "New Value";

    @Deployment
    public static PortletArchive createDeployment() {
        TestDeployment deployment = new TestDeployment(ExceptionWithSuffixTest.class, true);
        getWebXml(deployment.webXml());
        deployment.archive()
                .createFacesPortlet("ExceptionWithSuffix", "Exception With Suffix Portlet", "test.xhtml")
                .addAsWebResource("pages/exception/test.xhtml", "test.xhtml")
                .addAsWebResource("pages/exception/error.xhtml", "updateModelException.xhtml")
                .addClass(ExceptionBean.class);
        return deployment.getFinalArchive();
    }

    private static void getWebXml(WebAppDescriptor webConfig) {
        webConfig.createErrorPage()
                     .exceptionType(UpdateModelException.class.getName())
                     .location("/updateModelException.jsf")
                     .up()
                 .createContextParam()
                     .paramName("javax.faces.DEFAULT_SUFFIX")
                     .paramValue(".xhtml")
                     .up();
    }

    @FindBy(jquery = "[id$=':in']")
    private WebElement inputField;

    @FindBy(jquery = "[id$=':sub']")
    private WebElement submitButton;

    @FindBy(id = "errorHeading")
    private WebElement heading;

    @ArquillianResource
    @PortalURL
    URL portalURL;

    @Drone
    WebDriver browser;

    protected WebDriver getBrowser() {
        return browser;
    }

    //FIXME Although testing the deployment separately results in the page being displayed, for some reason
    // we're not able to see the updated content in test method
    @Test
    @RunAsClient
    public void testErrorPageWithDefaultSuffixSet() throws Exception {
        browser.get(portalURL.toString());

        inputField.sendKeys(NEW_VALUE);
        submitButton.click();

        waitAjax().until().element(heading).is().present();
        assertTrue("Should have redirected to error page", heading.getText().contains("UpdateModelException"));
    }

}
