/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import java.text.MessageFormat;
import java.util.logging.Level;

public class DeleteCircleOfTrust
extends AuthenticatedCommand {
    private String realm;
    private String cot;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.superAdminUserValidation();
        this.realm = this.getStringOptionValue("realm", "/");
        this.cot = this.getStringOptionValue("cot");
        String[] params = new String[]{this.realm, this.cot};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_COT", params);
        try {
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            cotManager.deleteCircleOfTrust(this.realm, this.cot);
            Object[] obj = new Object[]{this.cot};
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("delete-circle-of-trust-succeeded"), obj));
            this.writeLog(0, Level.INFO, "SUCCEEDED_DELETE_COT", params);
        }
        catch (COTException e) {
            this.debugWarning("DeleteCircleOfTrust.handleRequest", e);
            String[] args = new String[]{this.realm, this.cot, e.getMessage()};
            this.writeLog(1, Level.INFO, "FAILED_DELETE_COT", args);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

