/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.cot.COTException;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.workflow.AddProviderToCOT;
import com.sun.identity.workflow.CreateSAML2HostedProviderTemplate;
import com.sun.identity.workflow.ImportSAML2MetaData;
import com.sun.identity.workflow.Task;
import com.sun.identity.workflow.WorkflowException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CreateHostedIDP
extends Task {
    public String execute(Locale locale, Map params) throws WorkflowException {
        this.validateParameters(params);
        String metadataFile = this.getString(params, "metadata");
        boolean hasMetaData = metadataFile != null && metadataFile.trim().length() > 0;
        String metadata = null;
        String extendedData = null;
        if (hasMetaData) {
            String extendedDataFile = this.getString(params, "extendeddata");
            metadata = CreateHostedIDP.getContent(metadataFile, locale);
            extendedData = CreateHostedIDP.getContent(extendedDataFile, locale);
        } else {
            String entityId = this.getString(params, "entityId");
            String metaAlias = CreateHostedIDP.generateMetaAliasForIDP(this.getString(params, "realm"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("idp", metaAlias);
            map.put("idpecert", this.getString(params, "idpecert"));
            map.put("idpscert", this.getString(params, "idpscert"));
            try {
                metadata = CreateSAML2HostedProviderTemplate.buildMetaDataTemplate(entityId, map, this.getRequestURL(params));
                extendedData = CreateSAML2HostedProviderTemplate.createExtendedDataTemplate(entityId, map, this.getRequestURL(params));
            }
            catch (SAML2MetaException e) {
                return e.getMessage();
            }
        }
        String[] results = ImportSAML2MetaData.importData(null, metadata, extendedData);
        String realm = results[0];
        String entityId = results[1];
        String cot = this.getString(params, "cot");
        if (cot != null && cot.length() > 0) {
            try {
                AddProviderToCOT.addToCOT(realm, cot, entityId);
            }
            catch (COTException e) {
                throw new WorkflowException(e.getMessage());
            }
        }
        try {
            List attrMapping = this.getAttributeMapping(params);
            if (!attrMapping.isEmpty()) {
                SAML2MetaManager manager = new SAML2MetaManager();
                EntityConfigElement config = manager.getEntityConfig(realm, entityId);
                IDPSSOConfigElement ssoConfig = manager.getIDPSSOConfig(realm, entityId);
                Map attribConfig = SAML2MetaUtils.getAttributes((BaseConfigType)ssoConfig);
                List mappedAttributes = (List)attribConfig.get("attributeMap");
                mappedAttributes.addAll(attrMapping);
                manager.setEntityConfig(realm, config);
            }
        }
        catch (SAML2MetaException e) {
            throw new WorkflowException(e.getMessage());
        }
        try {
            return CreateHostedIDP.getMessage("idp.configured", locale) + "|||realm=" + realm + "&entityId=" + URLEncoder.encode(entityId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WorkflowException(e.getMessage());
        }
    }

    private void validateParameters(Map params) throws WorkflowException {
        boolean hasExtendedData;
        String metadata = this.getString(params, "metadata");
        boolean hasMetaData = metadata != null && metadata.trim().length() > 0;
        String extendedData = this.getString(params, "extendeddata");
        boolean bl = hasExtendedData = extendedData != null && extendedData.trim().length() > 0;
        if (hasMetaData && !hasExtendedData || !hasMetaData && hasExtendedData) {
            throw new WorkflowException("both-meta-extended-data-required", null);
        }
        if (params.size() == 3 && params.containsKey("metadata") && params.containsKey("extendeddata") && !hasMetaData && !hasExtendedData) {
            throw new WorkflowException("both-meta-extended-data-required", null);
        }
        String cotname = this.getString(params, "cot");
        if (cotname == null || cotname.trim().length() == 0) {
            throw new WorkflowException("missing-cot", null);
        }
        if (!hasMetaData && !hasExtendedData) {
            String realm = this.getString(params, "realm");
            if (realm == null || realm.trim().length() == 0) {
                throw new WorkflowException("missing-realm", null);
            }
            String entityId = this.getString(params, "entityId");
            if (entityId == null || entityId.trim().length() == 0) {
                throw new WorkflowException("missing-entity-id", null);
            }
        }
    }
}

