/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class DeleteSubConfiguration
extends SchemaCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String subConfigName = this.getStringOptionValue("subconfigname");
        String realmName = this.getStringOptionValue("realm");
        if (realmName == null || realmName.length() == 0) {
            this.deleteSubConfigToRoot(serviceName, subConfigName);
        } else {
            this.deleteSubConfigFromRealm(realmName, serviceName, subConfigName);
        }
    }

    private void deleteSubConfigFromRealm(String realmName, String serviceName, String subConfigName) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{realmName, subConfigName, serviceName};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_SUB_CONFIGURATION_TO_REALM", params);
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, adminSSOToken);
            ServiceConfig sc = scm.getOrganizationConfig(realmName, null);
            if (sc == null) {
                sc = scm.createOrganizationConfig(realmName, null);
            }
            this.deleteSubConfig(sc, subConfigName);
            this.writeLog(0, Level.INFO, "SUCCEED_DELETE_SUB_CONFIGURATION_TO_REALM", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("delete-sub-configuration-to-realm-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{realmName, subConfigName, serviceName, e.getMessage()};
            this.debugError("DeleteSubConfiguration.deleteSubConfigFromRealm", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_SUB_CONFIGURATIONT_TO_REALM", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realmName, subConfigName, serviceName, e.getMessage()};
            this.debugError("DeleteSubConfiguration.deleteSubConfigFromRealm", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_SUB_CONFIGURATIONT_TO_REALM", args);
            throw new CLIException(e, 127);
        }
    }

    private void deleteSubConfigToRoot(String serviceName, String subConfigName) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{subConfigName, serviceName};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_SUB_CONFIGURATION", params);
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, adminSSOToken);
            ServiceConfig sc = scm.getGlobalConfig(null);
            this.deleteSubConfig(sc, subConfigName);
            this.writeLog(0, Level.INFO, "SUCCEED_DELETE_SUB_CONFIGURATION", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("delete-sub-configuration-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{subConfigName, serviceName, e.getMessage()};
            this.debugError("DeleteSubConfiguration.deleteSubConfigToRoot", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_SUB_CONFIGURATION", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{subConfigName, serviceName, e.getMessage()};
            this.debugError("DeleteSubConfiguration.deleteSubConfigToRoot", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_SUB_CONFIGURATION", args);
            throw new CLIException(e, 127);
        }
    }

    private void deleteSubConfig(ServiceConfig sc, String subConfigName) throws SSOException, SMSException {
        StringTokenizer st = new StringTokenizer(subConfigName, "/");
        int tokenCount = st.countTokens();
        for (int i = 1; i <= tokenCount; ++i) {
            String scn = SMSSchema.unescapeName(st.nextToken());
            if (i != tokenCount) {
                sc = sc.getSubConfig(scn);
                continue;
            }
            sc.removeSubConfig(scn);
        }
    }
}

