/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.sm.SMSException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;

public class RemoveServerConfig
extends ServerConfigBase {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String serverName = this.getStringOptionValue("servername");
        List propertyNames = rc.getOption("propertynames");
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            String[] params = new String[]{serverName};
            this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_SERVER_CONFIG", params);
            if (serverName.equals("default")) {
                ServerConfiguration.removeServerConfiguration(adminSSOToken, "server-default", propertyNames);
            } else if (ServerConfiguration.isServerInstanceExist(adminSSOToken, serverName)) {
                ServerConfiguration.removeServerConfiguration(adminSSOToken, serverName, propertyNames);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("remove-server-config-succeeded"), params));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("remove-server-config-does-not-exists"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_REMOVE_SERVER_CONFIG", params);
        }
        catch (IOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("RemoveServerConfig.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_SERVER_CONFIG", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("RemoveServerConfig.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_SERVER_CONFIG", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("RemoveServerConfig.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_SERVER_CONFIG", args);
            throw new CLIException(e, 127);
        }
    }
}

