/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.Entitlement;
import com.sun.identity.entitlement.EntitlementCombiner;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.IPrivilege;
import com.sun.identity.entitlement.PrivilegeEvaluator;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ResourceSaveIndexes;
import com.sun.identity.entitlement.interfaces.ResourceName;
import com.sun.identity.entitlement.util.JSONUtils;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferralPrivilege
implements IPrivilege,
Cloneable {
    private String name;
    private String description;
    private Map<String, Set<String>> mapApplNameToResources;
    private Map<String, Set<String>> origMapApplNameToResources;
    private Set<String> realms;
    private long creationDate;
    private long lastModifiedDate;
    private String lastModifiedBy;
    private String createdBy;
    private boolean active = true;

    private ReferralPrivilege() {
    }

    public ReferralPrivilege(String name, Map<String, Set<String>> map, Set<String> realms) throws EntitlementException {
        if (name == null || name.trim().length() == 0) {
            throw new EntitlementException(250);
        }
        this.name = name;
        this.setMapApplNameToResources(map);
        this.setRealms(realms);
    }

    public Object clone() {
        ReferralPrivilege clone = new ReferralPrivilege();
        clone.name = this.name;
        clone.description = this.description;
        if (this.realms != null) {
            clone.realms = new HashSet<String>();
            clone.realms.addAll(this.realms);
        }
        clone.creationDate = this.creationDate;
        clone.lastModifiedDate = this.lastModifiedDate;
        clone.lastModifiedBy = this.lastModifiedBy;
        clone.createdBy = this.createdBy;
        if (this.mapApplNameToResources != null) {
            clone.mapApplNameToResources = new HashMap<String, Set<String>>();
            for (String k : this.mapApplNameToResources.keySet()) {
                HashSet s = new HashSet();
                s.addAll(this.mapApplNameToResources.get(k));
                clone.mapApplNameToResources.put(k, s);
            }
        }
        return clone;
    }

    public static ReferralPrivilege getInstance(JSONObject jo) {
        try {
            ReferralPrivilege r = new ReferralPrivilege();
            r.name = jo.optString("name");
            r.description = jo.optString("description");
            if (jo.has("createdBy")) {
                r.createdBy = jo.getString("createdBy");
            }
            if (jo.has("lastModifiedBy")) {
                r.lastModifiedBy = jo.getString("lastModifiedBy");
            }
            r.creationDate = JSONUtils.getLong(jo, "creationDate");
            r.lastModifiedDate = JSONUtils.getLong(jo, "lastModifiedDate");
            r.mapApplNameToResources = JSONUtils.getMapStringSetString(jo, "mapApplNameToResources");
            r.origMapApplNameToResources = JSONUtils.getMapStringSetString(jo, "origMapApplNameToResources");
            r.realms = JSONUtils.getSet(jo, "realms");
            return r;
        }
        catch (JSONException ex) {
            PrivilegeManager.debug.error("ReferralPrivilege.getInstance", (Throwable)ex);
            return null;
        }
    }

    public void setMapApplNameToResources(Map<String, Set<String>> map) throws EntitlementException {
        if (map != null) {
            for (String k : map.keySet()) {
                Set<String> v = map.get(k);
                if (v != null && !v.isEmpty()) continue;
                throw new EntitlementException(251);
            }
        }
        this.mapApplNameToResources = new HashMap<String, Set<String>>();
        if (map != null) {
            this.mapApplNameToResources.putAll(map);
        }
    }

    public void setRealms(Set<String> realms) throws EntitlementException {
        this.realms = new HashSet<String>();
        if (realms != null && !realms.isEmpty()) {
            this.realms.addAll(realms);
        }
    }

    public Map<String, Set<String>> getMapApplNameToResources() {
        return ReferralPrivilege.deepCopyMap(this.mapApplNameToResources);
    }

    private static Map<String, Set<String>> deepCopyMap(Map<String, Set<String>> map) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String k : map.keySet()) {
            HashSet set = new HashSet();
            set.addAll(map.get(k));
            result.put(k, set);
        }
        return result;
    }

    public Map<String, Set<String>> getOriginalMapApplNameToResources() {
        return this.origMapApplNameToResources != null ? ReferralPrivilege.deepCopyMap(this.origMapApplNameToResources) : ReferralPrivilege.deepCopyMap(this.mapApplNameToResources);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<String> getRealms() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.realms);
        return set;
    }

    @Override
    public ResourceSaveIndexes getResourceSaveIndexes(Subject adminSubject, String realm) {
        ResourceSaveIndexes result = null;
        for (String app : this.mapApplNameToResources.keySet()) {
            Application appl = ApplicationManager.getApplication(adminSubject, realm, app);
            for (String r : this.mapApplNameToResources.get(app)) {
                ResourceSaveIndexes rsi = appl.getResourceSaveIndex(r);
                if (result == null) {
                    result = rsi;
                    continue;
                }
                result.addAll(rsi);
            }
        }
        return result;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String toXML() {
        return this.toJSON();
    }

    public String toJSON() {
        JSONObject jo = new JSONObject();
        try {
            jo.put("name", (Object)this.name);
            jo.put("description", (Object)this.description);
            jo.put("createdBy", (Object)this.createdBy);
            jo.put("lastModifiedBy", (Object)this.lastModifiedBy);
            jo.put("creationDate", this.creationDate);
            jo.put("lastModifiedDate", this.lastModifiedDate);
            jo.put("mapApplNameToResources", this.mapApplNameToResources);
            if (this.origMapApplNameToResources != null) {
                jo.put("origMapApplNameToResources", this.origMapApplNameToResources);
            }
            jo.put("realms", this.realms);
            return jo.toString(2);
        }
        catch (JSONException ex) {
            PrivilegeManager.debug.error("ReferralPrivilege.toJSON", (Throwable)ex);
            return "";
        }
    }

    public void canonicalizeResources(Subject adminSubject, String realm) throws EntitlementException {
        this.origMapApplNameToResources = ReferralPrivilege.deepCopyMap(this.mapApplNameToResources);
        for (String appName : this.mapApplNameToResources.keySet()) {
            ResourceName resComp = this.getResourceComparator(adminSubject, realm, appName);
            Set<String> resources = this.mapApplNameToResources.get(appName);
            HashSet<String> temp = new HashSet<String>();
            for (String r : resources) {
                temp.add(resComp.canonicalize(r));
            }
            this.mapApplNameToResources.put(appName, temp);
        }
    }

    private ResourceName getResourceComparator(Subject adminSubject, String realm, String applName) {
        Application appl = ApplicationManager.getApplication(adminSubject, realm, applName);
        return appl.getResourceComparator();
    }

    @Override
    public List<Entitlement> evaluate(Subject adminSubject, String realm, Subject subject, String applicationName, String resourceName, Set<String> actionNames, Map<String, Set<String>> environment, boolean recursive) throws EntitlementException {
        List<Entitlement> results = null;
        if (!this.active) {
            return Collections.EMPTY_LIST;
        }
        for (String rlm : this.realms) {
            for (String app : this.mapApplNameToResources.keySet()) {
                if (!app.equals(applicationName)) continue;
                Set<String> resourceNames = this.mapApplNameToResources.get(app);
                ResourceName comp = this.getResourceComparator(adminSubject, rlm, app);
                String resName = comp.canonicalize(resourceName).toLowerCase();
                Set<String> resources = this.tagswapResourceNames(subject, resourceNames);
                boolean applicable = false;
                for (String r : resources) {
                    ResourceMatch match = comp.compare(resName, comp.canonicalize(r), true);
                    if (!recursive) {
                        applicable = match.equals(ResourceMatch.EXACT_MATCH) || match.equals(ResourceMatch.WILDCARD_MATCH) || match.equals(ResourceMatch.SUB_RESOURCE_MATCH);
                    } else {
                        boolean bl = applicable = !match.equals(ResourceMatch.NO_MATCH);
                    }
                    if (!applicable) continue;
                    break;
                }
                if (!applicable) continue;
                Application application = ApplicationManager.getApplication(adminSubject, realm, app);
                EntitlementCombiner entitlementCombiner = application.getEntitlementCombiner();
                entitlementCombiner.init(adminSubject, rlm, applicationName, resName, actionNames, recursive);
                PrivilegeEvaluator evaluator = new PrivilegeEvaluator();
                List<Entitlement> entitlements = evaluator.evaluate(rlm, adminSubject, subject, applicationName, resName, environment, recursive);
                if (results == null) {
                    results = entitlements;
                    continue;
                }
                if (entitlements == null) continue;
                entitlementCombiner.add(entitlements);
                results = entitlementCombiner.getResults();
            }
        }
        return results;
    }

    private Set<String> tagswapResourceNames(Subject sbj, Set<String> set) throws EntitlementException {
        Set<Principal> principals;
        HashSet<String> resources = new HashSet<String>();
        HashSet<String> userIds = new HashSet<String>();
        if (sbj != null && !(principals = sbj.getPrincipals()).isEmpty()) {
            for (Principal p : principals) {
                String pName = p.getName();
                if (DN.isDN((String)pName)) {
                    String[] rdns = LDAPDN.explodeDN((String)pName, (boolean)true);
                    userIds.add(rdns[0]);
                    continue;
                }
                userIds.add(pName);
            }
        }
        if (!userIds.isEmpty()) {
            for (String r : set) {
                for (String uid : userIds) {
                    resources.add(r.replaceAll("\\$SELF", uid));
                }
            }
        } else {
            resources.addAll(set);
        }
        return resources;
    }

    public Set<String> getApplicationTypeNames(Subject adminSubject, String realm) {
        HashSet<String> results = new HashSet<String>();
        for (String a : this.mapApplNameToResources.keySet()) {
            Application appl = ApplicationManager.getApplication(adminSubject, realm, a);
            results.add(appl.getApplicationType().getName());
        }
        return results;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

