/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.FormatUtils;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RealmGetServiceAttributeValues
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String serviceName = this.getStringOptionValue("servicename");
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{realm, serviceName};
            this.writeLog(0, Level.INFO, "ATTEMPT_GET_REALM_SERVICE_ATTR_VALUES", params);
            Map attributeValues = null;
            AMIdentityRepository repo = new AMIdentityRepository(adminSSOToken, realm);
            AMIdentity ai = repo.getRealmIdentity();
            Set servicesFromIdRepo = ai.getAssignedServices();
            if (servicesFromIdRepo.contains(serviceName)) {
                attributeValues = ai.getServiceAttributes(serviceName);
            } else {
                OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
                attributeValues = ocm.getServiceAttributes(serviceName);
            }
            if (attributeValues != null && !attributeValues.isEmpty()) {
                outputWriter.printlnMessage(FormatUtils.printAttributeValues(this.getResourceString("get-service-attr-values-of-realm-result"), attributeValues, CLIUtil.getPasswordFields(serviceName)));
            } else {
                outputWriter.printlnMessage(this.getResourceString("get-service-attr-values-of-realm-no-attr"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_GET_REALM_SERVICE_ATTR_VALUES", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmGetServiceAttributeValues.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_REALM_SERVICE_ATTR_VALUES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmGetServiceAttributeValues.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_GET_REALM_SERVICE_ATTR_VALUES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmGetServiceAttributeValues.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_REALM_SERVICE_ATTR_VALUES", args);
            throw new CLIException(e, 127);
        }
    }
}

