/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.database;

import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class RepoConfigHelper {
    private Debug debug;

    public RepoConfigHelper(Debug debug) {
        this.debug = debug;
    }

    public int getPropertyIntValue(Map configParams, String key, int defaultValue) {
        int value = defaultValue;
        try {
            Set valueSet = (Set)configParams.get(key);
            if (valueSet != null && !valueSet.isEmpty()) {
                value = Integer.parseInt((String)valueSet.iterator().next());
            }
        }
        catch (NumberFormatException nfe) {
            value = defaultValue;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("    RepoConfigHelper.getPropertyIntValue(): " + key + " = " + value);
        }
        return value;
    }

    public String getPropertyStringValue(Map configParams, String key, String defaultVal) {
        String value = this.getPropertyStringValue(configParams, key);
        if (value == null) {
            value = defaultVal;
        }
        return value;
    }

    public String getPropertyStringValue(Map configParams, String key) {
        String value = null;
        Set valueSet = (Set)configParams.get(key);
        if (valueSet != null && !valueSet.isEmpty()) {
            value = (String)valueSet.iterator().next();
        } else if (this.debug.messageEnabled()) {
            this.debug.message("RepoConfigHelper.getPropertyStringValue failedto set value for:" + key);
        }
        return value;
    }

    public boolean getPropertyBooleanValue(Map configParams, String key) {
        String value = this.getPropertyStringValue(configParams, key);
        return value != null && value.equalsIgnoreCase("true");
    }

    public Map parsedUserSpecifiedOps(Set userSpecifiedOpsSet) {
        if (this.debug.messageEnabled()) {
            this.debug.message("RepoConfigHelper.parsedUserSpecifiedOps entry: userSpecifiedOpsSet:" + userSpecifiedOpsSet);
        }
        IdType idTypeRead = null;
        Object opsREAD = null;
        HashMap<IdType, Set> supportedOps = new HashMap<IdType, Set>();
        Iterator it = userSpecifiedOpsSet.iterator();
        while (it.hasNext()) {
            idTypeRead = null;
            Set opsRead = null;
            String curr = (String)it.next();
            StringTokenizer st = new StringTokenizer(curr, "= ,");
            if (st.hasMoreTokens()) {
                String idtypeToken = st.nextToken();
                if (this.debug.messageEnabled()) {
                    this.debug.message("    idtypeToken:" + idtypeToken);
                }
                if (idtypeToken.equalsIgnoreCase("user")) {
                    idTypeRead = IdType.USER;
                    opsRead = this.parseInputedOps(st, true);
                } else if (idtypeToken.equalsIgnoreCase("group")) {
                    idTypeRead = IdType.GROUP;
                    opsRead = this.parseInputedOps(st, false);
                } else if (idtypeToken.equalsIgnoreCase("agent")) {
                    idTypeRead = IdType.AGENT;
                    opsRead = this.parseInputedOps(st, false);
                } else if (idtypeToken.equalsIgnoreCase("role")) {
                    idTypeRead = IdType.ROLE;
                    opsRead = this.parseInputedOps(st, false);
                } else if (idtypeToken.equalsIgnoreCase("filteredrole")) {
                    idTypeRead = IdType.FILTEREDROLE;
                    opsRead = this.parseInputedOps(st, false);
                } else if (idtypeToken.equalsIgnoreCase("realm")) {
                    idTypeRead = IdType.REALM;
                    opsRead = this.parseInputedOps(st, true);
                } else {
                    idTypeRead = null;
                }
            }
            if (idTypeRead == null || opsRead == null || opsRead.isEmpty()) continue;
            supportedOps.put(idTypeRead, opsRead);
            if (!this.debug.messageEnabled()) continue;
            this.debug.message("RepoConfigHelper.parsedUserSpecifiedOps called supportedOps:" + supportedOps + "; idTypeRead:" + idTypeRead + "; opsRead:" + opsRead);
        }
        return supportedOps;
    }

    public Set parseInputedOps(StringTokenizer st, boolean supportService) {
        HashSet<IdOperation> opsReadSet = new HashSet<IdOperation>();
        while (st.hasMoreTokens()) {
            String idOpToken = st.nextToken();
            if (idOpToken.equalsIgnoreCase("read")) {
                opsReadSet.add(IdOperation.READ);
                continue;
            }
            if (idOpToken.equalsIgnoreCase("edit")) {
                opsReadSet.add(IdOperation.EDIT);
                continue;
            }
            if (idOpToken.equalsIgnoreCase("create")) {
                opsReadSet.add(IdOperation.CREATE);
                continue;
            }
            if (idOpToken.equalsIgnoreCase("delete")) {
                opsReadSet.add(IdOperation.DELETE);
                continue;
            }
            if (!idOpToken.equalsIgnoreCase("service") || !supportService) continue;
            opsReadSet.add(IdOperation.SERVICE);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("RepoConfigHelper.parseInputedOps done: opsReadSet:" + opsReadSet);
        }
        return opsReadSet;
    }
}

