/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.sun.identity.setup.InstallLog;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SetupProgress {
    private static Writer writer = null;
    private static String bundleName = "amConfigurator";
    private static OutputStream out = null;
    private static String encoding = System.getProperty("file.encoding");
    private static ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
    private static boolean isTextMode = false;

    public static Writer getWriter() {
        return writer;
    }

    static void setLocale(Locale locale) {
        bundle = ResourceBundle.getBundle(bundleName, locale);
    }

    public static OutputStream getOutputStream() {
        return out;
    }

    public static void setWriter(Writer w) {
        writer = w;
        if (writer == null) {
            out = null;
            return;
        }
        out = isTextMode ? new OutputStream(){

            public void write(int b) throws IOException {
                writer.write(URLEncoder.encode(String.valueOf((char)b), encoding));
                writer.flush();
            }

            public void write(byte[] b) throws IOException {
                writer.write(URLEncoder.encode(new String(b, encoding), encoding));
                writer.flush();
            }

            public void write(byte[] b, int off, int len) throws IOException {
                writer.write(URLEncoder.encode(new String(b, off, len, encoding), encoding));
                writer.flush();
            }

            public void flush() throws IOException {
                writer.flush();
            }
        } : new OutputStream(){

            public void write(int b) throws IOException {
                writer.write("<script>addProgressText('");
                writer.write(URLEncoder.encode(String.valueOf((char)b), encoding));
                writer.write("<br>');</script>");
                writer.flush();
            }

            public void write(byte[] b) throws IOException {
                writer.write("<script>addProgressText('");
                writer.write(URLEncoder.encode(new String(b, encoding), encoding));
                writer.write("<br>');</script>");
                writer.flush();
            }

            public void write(byte[] b, int off, int len) throws IOException {
                writer.write("<script>addProgressText('");
                writer.write(URLEncoder.encode(new String(b, off, len, encoding), encoding));
                writer.write("<br>');</script>");
                writer.flush();
            }

            public void flush() throws IOException {
                writer.flush();
            }
        };
    }

    public static void setOutputStream(OutputStream ostr) {
        out = ostr;
    }

    public static void setTextMode(boolean textMode) {
        isTextMode = textMode;
    }

    public static void reportStart(String str, Object[] param) {
        SetupProgress.writeProgressText(str, param, false);
    }

    public static void reportEnd(String str, Object[] param) {
        SetupProgress.writeProgressText(str, param, true);
    }

    private static void writeProgressText(String str, Object[] param, boolean newline) {
        String istr = null;
        try {
            istr = bundle.getString(str);
            if (param != null && param.length > 0) {
                istr = MessageFormat.format(istr, param);
            }
        }
        catch (MissingResourceException e) {
            istr = str;
        }
        SetupProgress.reportDebug(istr, newline);
    }

    private static void reportDebug(String istr, boolean newline) {
        try {
            if (newline) {
                InstallLog.getInstance().write(istr + "\n");
            } else {
                InstallLog.getInstance().write(istr);
            }
            if (writer != null) {
                if (isTextMode) {
                    if (newline) {
                        istr = istr + "\n";
                    }
                    writer.write(istr);
                } else {
                    if (newline) {
                        istr = istr + "<br />";
                    }
                    writer.write("<script>addProgressText('" + istr + "');</script>");
                }
                writer.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

