/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.sun.identity.security.DecodeAction;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.ChoiceValues;
import com.sun.identity.sm.DefaultValues;
import com.sun.identity.sm.SMSEntry;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeSchemaImpl {
    private Node attrSchemaNode;
    private String name;
    private String key;
    private AttributeSchema.Type type;
    private AttributeSchema.UIType uitype;
    private AttributeSchema.Syntax syntax;
    private Set defaultValues = null;
    private DefaultValues defaultsObject = null;
    private Map choiceValues;
    private ChoiceValues choiceObject = null;
    private String trueBooleanValue;
    private String trueValueKey;
    private String falseBooleanValue;
    private String falseValueKey;
    private String cosQualifier;
    private String rangeStart;
    private String rangeEnd;
    private int minValue;
    private int maxValue;
    private String validator;
    private boolean isOptional;
    private boolean isServiceIdentifier;
    private boolean isResourceNameAllowed;
    private boolean isStatusAttribute;
    private String any;
    private String attributeViewBeanURL;
    boolean isSearchable;

    protected AttributeSchemaImpl(Node node) {
        this.update(node);
    }

    public String getName() {
        return this.name;
    }

    public AttributeSchema.Type getType() {
        return this.type;
    }

    public AttributeSchema.UIType getUIType() {
        return this.uitype;
    }

    public AttributeSchema.Syntax getSyntax() {
        return this.syntax;
    }

    public String getI18NKey() {
        return this.key;
    }

    public String getCosQualifier() {
        return this.cosQualifier;
    }

    public Set getDefaultValues() {
        if (this.defaultsObject != null) {
            this.defaultValues = this.defaultsObject.getDefaultValues();
        }
        if (this.defaultValues != null && this.defaultValues.size() != 0) {
            HashSet answer = new HashSet();
            answer.addAll(this.defaultValues);
            return answer;
        }
        return Collections.EMPTY_SET;
    }

    public Set getDefaultValues(Map envParams) {
        if (this.defaultsObject != null) {
            this.defaultValues = this.defaultsObject.getDefaultValues(envParams);
        }
        if (this.defaultValues != null && this.defaultValues.size() != 0) {
            HashSet answer = new HashSet();
            answer.addAll(this.defaultValues);
            return answer;
        }
        return Collections.EMPTY_SET;
    }

    public String[] getChoiceValues() {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues();
        }
        if (this.choiceValues != null) {
            Set ret = this.choiceValues.keySet();
            return ret.toArray(new String[ret.size()]);
        }
        return null;
    }

    public String[] getChoiceValues(Map envParams) {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues(envParams);
        }
        if (this.choiceValues != null) {
            Set ret = this.choiceValues.keySet();
            return ret.toArray(new String[ret.size()]);
        }
        return null;
    }

    protected Map getChoiceValuesMap() {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues();
        }
        if (this.choiceValues != null) {
            return this.choiceValues;
        }
        return new HashMap();
    }

    protected Set getChoiceValuesSet() {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues();
        }
        if (this.choiceValues != null) {
            return this.choiceValues.keySet();
        }
        return new HashSet();
    }

    protected Map getChoiceValuesMap(Map envParams) {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues(envParams);
        }
        if (this.choiceValues != null) {
            return this.choiceValues;
        }
        return new HashMap();
    }

    protected Set getChoiceValuesSet(Map envParams) {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues(envParams);
        }
        if (this.choiceValues != null) {
            return this.choiceValues.keySet();
        }
        return new HashSet();
    }

    public String getChoiceValueI18NKey(String cValue) {
        if (this.choiceObject != null) {
            this.choiceValues = this.choiceObject.getChoiceValues();
        }
        return (String)this.choiceValues.get(cValue);
    }

    public String getStartRange() {
        return this.rangeStart;
    }

    public String getEndRange() {
        return this.rangeEnd;
    }

    public String getValidator() {
        return this.validator;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public String getTrueValue() {
        return this.trueBooleanValue;
    }

    public String getTrueValueI18NKey() {
        return this.trueValueKey;
    }

    public String getFalseValue() {
        return this.falseBooleanValue;
    }

    public String getFalseValueI18NKey() {
        return this.falseValueKey;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isServiceIdentifier() {
        return this.isServiceIdentifier;
    }

    public boolean isResourceNameAllowed() {
        return this.isResourceNameAllowed;
    }

    public boolean isStatusAttribute() {
        return this.isStatusAttribute;
    }

    public String getAny() {
        return this.any;
    }

    public String getPropertiesViewBeanURL() {
        return this.attributeViewBeanURL;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Attr Name=").append(this.name);
        buf.append("\n\tType=").append(this.type);
        buf.append("\n\tUIType=").append(this.uitype);
        buf.append("\n\tSyntax=").append(this.syntax);
        buf.append("\n\tI18n Key=").append(this.key);
        buf.append("\n\tDefault values=").append(this.defaultValues);
        buf.append("\n\tChoice Values=").append(this.choiceValues);
        buf.append("\n\tRangeStart=").append(this.rangeStart);
        buf.append("\n\tRangeEnd=").append(this.rangeEnd);
        buf.append("\n\tMinValue=").append(this.minValue);
        buf.append("\n\tMaxValue=").append(this.maxValue);
        buf.append("\n\tCoS Qualifier=").append(this.cosQualifier);
        buf.append("\n\tAny=").append(this.any);
        buf.append("\n\tView Bean URL=").append(this.attributeViewBeanURL);
        buf.append("\n\tisOptional=").append(this.isOptional);
        buf.append("\n\tisServiceIdentifier=").append(this.isServiceIdentifier);
        buf.append("\n\tisResourceNameAllowed=").append(this.isResourceNameAllowed);
        buf.append("\n\tisStatusAttribute=").append(this.isStatusAttribute);
        buf.append("\n\tisSearchable=").append(this.isSearchable);
        buf.append("\n");
        return buf.toString();
    }

    void update(Node n) {
        Node choiceValueNode;
        Node node;
        Node booleanValue;
        this.attrSchemaNode = n;
        this.name = XMLUtils.getNodeAttributeValue((Node)n, (String)"name");
        this.key = XMLUtils.getNodeAttributeValue((Node)n, (String)"i18nKey");
        String attrType = XMLUtils.getNodeAttributeValue((Node)n, (String)"type");
        this.type = AttributeSchema.Type.LIST;
        if (attrType != null) {
            try {
                Class<?> attrClass = AttributeSchema.Type.LIST.getClass();
                this.type = (AttributeSchema.Type)attrClass.getField(attrType.toUpperCase()).get(AttributeSchema.Type.LIST);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String attrUIType = XMLUtils.getNodeAttributeValue((Node)n, (String)"uitype");
        this.uitype = null;
        if (attrUIType != null) {
            try {
                Class<?> attrClass = AttributeSchema.UIType.LINK.getClass();
                this.uitype = (AttributeSchema.UIType)attrClass.getField(attrUIType.toUpperCase()).get(AttributeSchema.UIType.LINK);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String attrSyntax = XMLUtils.getNodeAttributeValue((Node)n, (String)"syntax");
        this.syntax = AttributeSchema.Syntax.STRING;
        if (attrSyntax != null) {
            try {
                Class<?> syntaxClass = AttributeSchema.Syntax.STRING.getClass();
                this.syntax = (AttributeSchema.Syntax)syntaxClass.getField(attrSyntax.toUpperCase()).get(AttributeSchema.Syntax.STRING);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.syntax.equals(AttributeSchema.Syntax.BOOLEAN) && (booleanValue = XMLUtils.getChildNode((Node)n, (String)"BooleanValues")) != null) {
            node = XMLUtils.getChildNode((Node)booleanValue, (String)"BooleanTrueValue");
            if (node != null) {
                this.trueBooleanValue = XMLUtils.getValueOfValueNode((Node)node);
                this.trueValueKey = XMLUtils.getNodeAttributeValue((Node)node, (String)"i18nKey");
            } else {
                this.trueBooleanValue = "true";
            }
            node = XMLUtils.getChildNode((Node)booleanValue, (String)"BooleanFalseValue");
            if (node != null) {
                this.falseBooleanValue = XMLUtils.getValueOfValueNode((Node)node);
                this.falseValueKey = XMLUtils.getNodeAttributeValue((Node)node, (String)"i18nKey");
            } else {
                this.falseBooleanValue = "false";
            }
        } else {
            this.trueBooleanValue = "true";
            this.falseBooleanValue = "false";
        }
        if ((this.type.equals(AttributeSchema.Type.SINGLE_CHOICE) || this.type.equals(AttributeSchema.Type.MULTIPLE_CHOICE)) && (choiceValueNode = XMLUtils.getChildNode((Node)n, (String)"ChoiceValues")) != null) {
            Node cvClassName = XMLUtils.getChildNode((Node)choiceValueNode, (String)"ChoiceValuesClassName");
            if (cvClassName != null) {
                String className = XMLUtils.getNodeAttributeValue((Node)cvClassName, (String)"className");
                try {
                    Class<?> c = Class.forName(className);
                    this.choiceObject = (ChoiceValues)c.newInstance();
                    this.choiceObject.setAttributeSchema(this);
                    this.choiceObject.setKeyValues(cvClassName);
                    this.choiceObject.setParentNode(n);
                }
                catch (Exception e) {
                    SMSEntry.debug.error("SMS AttributeSchema: Unable to load class: " + className, (Throwable)e);
                    this.choiceObject = null;
                }
            }
            if (this.choiceObject == null) {
                this.choiceValues = new HashMap();
                for (Node cnode : XMLUtils.getChildNodes((Node)choiceValueNode, (String)"ChoiceValue")) {
                    String choiceValue = XMLUtils.getValueOfValueNode((Node)cnode);
                    String i18nKey = XMLUtils.getNodeAttributeValue((Node)cnode, (String)"i18nKey");
                    this.choiceValues.put(choiceValue, i18nKey);
                }
            }
        }
        if ((node = XMLUtils.getChildNode((Node)n, (String)"DefaultValues")) != null) {
            Node dvClassName = XMLUtils.getChildNode((Node)node, (String)"DefaultValuesClassName");
            if (dvClassName != null) {
                String className = XMLUtils.getNodeAttributeValue((Node)dvClassName, (String)"className");
                try {
                    Class<?> c = Class.forName(className);
                    this.defaultsObject = (DefaultValues)c.newInstance();
                    this.defaultsObject.setAttributeSchema(this);
                    this.defaultsObject.setKeyValues(dvClassName);
                    this.defaultsObject.setParentNode(n);
                }
                catch (Exception e) {
                    SMSEntry.debug.error("SMS AttributeSchema: Unable to load class: " + className, (Throwable)e);
                    this.defaultValues = AttributeSchemaImpl.getValues(node);
                }
            } else {
                this.defaultValues = AttributeSchemaImpl.getValues(node);
            }
        }
        if ((this.syntax.equals(AttributeSchema.Syntax.PASSWORD) || this.syntax.equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) && this.defaultValues != null) {
            Iterator iter = this.defaultValues.iterator();
            this.defaultValues = new HashSet();
            while (iter.hasNext()) {
                String value = (String)iter.next();
                if (value != null) {
                    try {
                        value = (String)AccessController.doPrivileged(new DecodeAction(value));
                    }
                    catch (Throwable e) {
                        SMSEntry.debug.error("AttributeSchemaImpl: Unable to decode", e);
                    }
                }
                this.defaultValues.add(value);
            }
        }
        if ((this.cosQualifier = XMLUtils.getNodeAttributeValue((Node)n, (String)"cosQualifier")) == null) {
            this.cosQualifier = "default";
        }
        this.rangeStart = XMLUtils.getNodeAttributeValue((Node)n, (String)"rangeStart");
        this.rangeEnd = XMLUtils.getNodeAttributeValue((Node)n, (String)"rangeEnd");
        try {
            this.minValue = Integer.parseInt(XMLUtils.getNodeAttributeValue((Node)n, (String)"minValue"));
        }
        catch (NumberFormatException e) {
            this.minValue = -1;
        }
        try {
            this.maxValue = Integer.parseInt(XMLUtils.getNodeAttributeValue((Node)n, (String)"maxValue"));
        }
        catch (NumberFormatException e) {
            this.maxValue = -1;
        }
        this.validator = XMLUtils.getNodeAttributeValue((Node)n, (String)"validator");
        if (XMLUtils.getChildNode((Node)n, (String)"IsOptional") != null) {
            this.isOptional = true;
        }
        this.isServiceIdentifier = false;
        if (XMLUtils.getChildNode((Node)n, (String)"IsServiceIdentifier") != null) {
            this.isServiceIdentifier = true;
        }
        this.isResourceNameAllowed = false;
        if (XMLUtils.getChildNode((Node)n, (String)"IsResourceNameAllowed") != null) {
            this.isResourceNameAllowed = true;
        }
        this.isStatusAttribute = false;
        if (XMLUtils.getChildNode((Node)n, (String)"IsStatusAttribute") != null) {
            this.isStatusAttribute = true;
        }
        this.any = XMLUtils.getNodeAttributeValue((Node)n, (String)"any");
        this.attributeViewBeanURL = XMLUtils.getNodeAttributeValue((Node)n, (String)"propertiesViewBeanURL");
        this.isSearchable = false;
        String srch = XMLUtils.getNodeAttributeValue((Node)n, (String)"isSearchable");
        if (srch != null && srch.equalsIgnoreCase("yes")) {
            this.isSearchable = true;
        }
    }

    protected static Set getValues(Node node) {
        HashSet<String> retVal = new HashSet<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!n.getNodeName().equals("Value")) continue;
            retVal.add(XMLUtils.getValueOfValueNode((Node)n));
        }
        return retVal;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }
}

