#!/bin/sh

# Portal Setup Utility
#
# A simple utility for setting portal root user password
#

DIRNAME=`dirname "$0"`

# OS specific support (must be 'true' or 'false').
cygwin=false;
if [ `uname|grep -i CYGWIN` ]; then
    cygwin = true;
fi

# For Cygwin, ensure paths are in UNIX format before anything is touched
if $cygwin ; then
    [ -n "$JBOSS_HOME" ] &&
        JBOSS_HOME=`cygpath --unix "$JBOSS_HOME"`
    [ -n "$JAVA_HOME" ] &&
        JAVA_HOME=`cygpath --unix "$JAVA_HOME"`
    [ -n "$JAVAC_JAR" ] &&
        JAVAC_JAR=`cygpath --unix "$JAVAC_JAR"`
fi

# Setup JBOSS_HOME
RESOLVED_JBOSS_HOME=`cd "$DIRNAME/.."; pwd`
if [ "x$JBOSS_HOME" = "x" ]; then
    # get the full path (without any relative bits)
    JBOSS_HOME=$RESOLVED_JBOSS_HOME
else
    SANITIZED_JBOSS_HOME=`cd "$JBOSS_HOME"; pwd`
    if [ "$RESOLVED_JBOSS_HOME" != "$SANITIZED_JBOSS_HOME" ]; then
        echo "WARNING JBOSS_HOME may be pointing to a different installation - unpredictable results may occur."
        echo ""
    fi
fi
export JBOSS_HOME

# Setup the JVM
if [ "x$JAVA" = "x" ]; then
    if [ "x$JAVA_HOME" != "x" ]; then
        JAVA="$JAVA_HOME/bin/java"
    else
        JAVA="java"
    fi
fi

if [ "x$JBOSS_MODULEPATH" = "x" ]; then
    JBOSS_MODULEPATH="$JBOSS_HOME/modules/system/layers"
fi

# For Cygwin, switch paths to Windows format before running java
if $cygwin; then
    JBOSS_HOME=`cygpath --path --windows "$JBOSS_HOME"`
    JAVA_HOME=`cygpath --path --windows "$JAVA_HOME"`
    JBOSS_CLASSPATH=`cygpath --path --windows "$JBOSS_CLASSPATH"`
    JBOSS_ENDORSED_DIRS=`cygpath --path --windows "$JBOSS_ENDORSED_DIRS"`
    JBOSS_MODULEPATH=`cygpath --path --windows "$JBOSS_MODULEPATH"`
fi

# Sample JPDA settings for remote socket debugging
#JAVA_OPTS="$JAVA_OPTS -Xrunjdwp:transport=dt_socket,address=8787,server=y,suspend=y"

SCRIPT_CLASSPATH="$JBOSS_MODULEPATH/gatein/org/gatein/lib/main/*"
SCRIPT_CLASSPATH="$SCRIPT_CLASSPATH\:$JBOSS_MODULEPATH/gatein/org/gatein/common/main/*"
SCRIPT_CLASSPATH="$SCRIPT_CLASSPATH\:$JBOSS_MODULEPATH/gatein/org/picocontainer/main/*"
SCRIPT_CLASSPATH="$SCRIPT_CLASSPATH\:$JBOSS_MODULEPATH/base/org/slf4j/main/*"
SCRIPT_CLASSPATH="$SCRIPT_CLASSPATH\:$JBOSS_MODULEPATH/base/org/slf4j/impl/main/*"
SCRIPT_CLASSPATH="$SCRIPT_CLASSPATH\:$JBOSS_MODULEPATH/base/org/slf4j/jcl-over-slf4j/main/*"
SCRIPT_CLASSPATH="$SCRIPT_CLASSPATH\:$JBOSS_MODULEPATH/base/org/jboss/logmanager/main/*"

eval \"$JAVA\" $JAVA_OPTS \
         -cp $SCRIPT_CLASSPATH \
         org.gatein.portal.installer.PortalSetupCommand \
         -f \"$JBOSS_HOME/standalone/configuration/gatein/configuration.properties\" \
         "$@"
