package io.quarkus.hibernate.validator.runtime;

import org.hibernate.validator.metadata.BeanMetaDataClassNormalizer;

import io.quarkus.arc.Subclass;

/**
 * In the case of a proxy generated by Arc, return the parent class.
 */
public class ArcProxyBeanMetaDataClassNormalizer implements BeanMetaDataClassNormalizer {

    @Override
    public Class<?> normalize(Class<?> clazz) {
        if (Subclass.class.isAssignableFrom(clazz)) {
            return clazz.getSuperclass();
        }

        return clazz;
    }

}
