/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.rest.openapi.RestOpenApiComponent;

/**
 * Configure REST producers based on an OpenAPI specification document
 * delegating to a component implementing the RestProducerFactory interface.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface RestOpenapiComponentBuilderFactory {

    /**
     * REST OpenApi (camel-rest-openapi)
     * Configure REST producers based on an OpenAPI specification document
     * delegating to a component implementing the RestProducerFactory interface.
     * 
     * Category: rest,api
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-rest-openapi
     * 
     * @return the dsl builder
     */
    static RestOpenapiComponentBuilder restOpenapi() {
        return new RestOpenapiComponentBuilderImpl();
    }

    /**
     * Builder for the REST OpenApi component.
     */
    interface RestOpenapiComponentBuilder
            extends
                ComponentBuilder<RestOpenApiComponent> {
        /**
         * API basePath, for example /v2. Default is unset, if set overrides the
         * value present in OpenApi specification.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param basePath the value to set
         * @return the dsl builder
         */
        default RestOpenapiComponentBuilder basePath(java.lang.String basePath) {
            doSetProperty("basePath", basePath);
            return this;
        }
        /**
         * Name of the Camel component that will perform the requests. The
         * component must be present in Camel registry and it must implement
         * RestProducerFactory service provider interface. If not set CLASSPATH
         * is searched for single component that implements RestProducerFactory
         * SPI. Can be overridden in endpoint configuration.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param componentName the value to set
         * @return the dsl builder
         */
        default RestOpenapiComponentBuilder componentName(
                java.lang.String componentName) {
            doSetProperty("componentName", componentName);
            return this;
        }
        /**
         * What payload type this component capable of consuming. Could be one
         * type, like application/json or multiple types as application/json,
         * application/xml; q=0.5 according to the RFC7231. This equates to the
         * value of Accept HTTP header. If set overrides any value found in the
         * OpenApi specification. Can be overridden in endpoint configuration.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param consumes the value to set
         * @return the dsl builder
         */
        default RestOpenapiComponentBuilder consumes(java.lang.String consumes) {
            doSetProperty("consumes", consumes);
            return this;
        }
        /**
         * Scheme hostname and port to direct the HTTP requests to in the form
         * of https://hostname:port. Can be configured at the endpoint,
         * component or in the corresponding REST configuration in the Camel
         * Context. If you give this component a name (e.g. petstore) that REST
         * configuration is consulted first, rest-openapi next, and global
         * configuration last. If set overrides any value found in the OpenApi
         * specification, RestConfiguration. Can be overridden in endpoint
         * configuration.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default RestOpenapiComponentBuilder host(java.lang.String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default RestOpenapiComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * What payload type this component is producing. For example
         * application/json according to the RFC7231. This equates to the value
         * of Content-Type HTTP header. If set overrides any value present in
         * the OpenApi specification. Can be overridden in endpoint
         * configuration.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param produces the value to set
         * @return the dsl builder
         */
        default RestOpenapiComponentBuilder produces(java.lang.String produces) {
            doSetProperty("produces", produces);
            return this;
        }
        /**
         * Path to the OpenApi specification file. The scheme, host base path
         * are taken from this specification, but these can be overridden with
         * properties on the component or endpoint level. If not given the
         * component tries to load openapi.json resource. Note that the host
         * defined on the component and endpoint of this Component should
         * contain the scheme, hostname and optionally the port in the URI
         * syntax (i.e. https://api.example.com:8080). Can be overridden in
         * endpoint configuration.
         * 
         * The option is a: &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Default: openapi.json
         * Group: producer
         * 
         * @param specificationUri the value to set
         * @return the dsl builder
         */
        default RestOpenapiComponentBuilder specificationUri(
                java.net.URI specificationUri) {
            doSetProperty("specificationUri", specificationUri);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default RestOpenapiComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * Customize TLS parameters used by the component. If not set defaults
         * to the TLS parameters set in the Camel context.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default RestOpenapiComponentBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Enable usage of global SSL context parameters.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useGlobalSslContextParameters the value to set
         * @return the dsl builder
         */
        default RestOpenapiComponentBuilder useGlobalSslContextParameters(
                boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }

    class RestOpenapiComponentBuilderImpl
            extends
                AbstractComponentBuilder<RestOpenApiComponent>
            implements
                RestOpenapiComponentBuilder {
        @Override
        protected RestOpenApiComponent buildConcreteComponent() {
            return new RestOpenApiComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "basePath": ((RestOpenApiComponent) component).setBasePath((java.lang.String) value); return true;
            case "componentName": ((RestOpenApiComponent) component).setComponentName((java.lang.String) value); return true;
            case "consumes": ((RestOpenApiComponent) component).setConsumes((java.lang.String) value); return true;
            case "host": ((RestOpenApiComponent) component).setHost((java.lang.String) value); return true;
            case "lazyStartProducer": ((RestOpenApiComponent) component).setLazyStartProducer((boolean) value); return true;
            case "produces": ((RestOpenApiComponent) component).setProduces((java.lang.String) value); return true;
            case "specificationUri": ((RestOpenApiComponent) component).setSpecificationUri((java.net.URI) value); return true;
            case "autowiredEnabled": ((RestOpenApiComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "sslContextParameters": ((RestOpenApiComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "useGlobalSslContextParameters": ((RestOpenApiComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            default: return false;
            }
        }
    }
}