/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package sample.camel;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.rest.RestParamType;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DataTypeConverterRouter extends RouteBuilder {

	@Value("${camel.servlet.mapping.context-path}")
	public String contextPath;

	@Override
	public void configure() throws Exception {

		restConfiguration()
			.component("servlet");

		rest("/convert")
				.produces("text/plain")
				.post()
				.to("direct:convert1");


		from("direct:convert1")
				.process(exchange -> {
					String inputString = exchange.getIn().getBody(String.class);
					byte[] inputBytes = inputString.getBytes();
					exchange.getOut().setBody(inputBytes);
				})
				.convertBodyTo(Person.class)
				.log("${body}");
	}
}