/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * IEC 60870 supervisory control and data acquisition (SCADA) server using
 * NeoSCADA implementation.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ServerEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the IEC 60870 Server component.
     */
    public interface ServerEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedServerEndpointConsumerBuilder advanced() {
            return (AdvancedServerEndpointConsumerBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder dataModuleOptions(
                org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder dataModuleOptions(
                String dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param filterNonExecute the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder filterNonExecute(
                boolean filterNonExecute) {
            doSetProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param filterNonExecute the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder filterNonExecute(
                String filterNonExecute) {
            doSetProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder protocolOptions(
                org.eclipse.neoscada.protocol.iec60870.ProtocolOptions protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder protocolOptions(
                String protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder acknowledgeWindow(
                short acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder acknowledgeWindow(
                String acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder adsuAddressType(
                org.eclipse.neoscada.protocol.iec60870.ASDUAddressType adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder adsuAddressType(
                String adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder causeOfTransmissionType(
                org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder informationObjectAddressType(
                org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder maxUnacknowledged(
                short maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder maxUnacknowledged(
                String maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder timeout1(int timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder timeout1(String timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder timeout2(int timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder timeout2(String timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder timeout3(int timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder timeout3(String timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder causeSourceAddress(
                byte causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder causeSourceAddress(
                String causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder timeZone(TimeZone timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder timeZone(String timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: id
         * 
         * @param connectionId the value to set
         * @return the dsl builder
         */
        default ServerEndpointConsumerBuilder connectionId(String connectionId) {
            doSetProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the IEC 60870 Server
     * component.
     */
    public interface AdvancedServerEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ServerEndpointConsumerBuilder basic() {
            return (ServerEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedServerEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedServerEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedServerEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedServerEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedServerEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedServerEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the IEC 60870 Server component.
     */
    public interface ServerEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedServerEndpointProducerBuilder advanced() {
            return (AdvancedServerEndpointProducerBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder dataModuleOptions(
                org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder dataModuleOptions(
                String dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param filterNonExecute the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder filterNonExecute(
                boolean filterNonExecute) {
            doSetProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param filterNonExecute the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder filterNonExecute(
                String filterNonExecute) {
            doSetProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder protocolOptions(
                org.eclipse.neoscada.protocol.iec60870.ProtocolOptions protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder protocolOptions(
                String protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder acknowledgeWindow(
                short acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder acknowledgeWindow(
                String acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder adsuAddressType(
                org.eclipse.neoscada.protocol.iec60870.ASDUAddressType adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder adsuAddressType(
                String adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder causeOfTransmissionType(
                org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder informationObjectAddressType(
                org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder maxUnacknowledged(
                short maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder maxUnacknowledged(
                String maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder timeout1(int timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder timeout1(String timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder timeout2(int timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder timeout2(String timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder timeout3(int timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder timeout3(String timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder causeSourceAddress(
                byte causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder causeSourceAddress(
                String causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder timeZone(TimeZone timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder timeZone(String timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: id
         * 
         * @param connectionId the value to set
         * @return the dsl builder
         */
        default ServerEndpointProducerBuilder connectionId(String connectionId) {
            doSetProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the IEC 60870 Server
     * component.
     */
    public interface AdvancedServerEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ServerEndpointProducerBuilder basic() {
            return (ServerEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedServerEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedServerEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the IEC 60870 Server component.
     */
    public interface ServerEndpointBuilder
            extends
                ServerEndpointConsumerBuilder,
                ServerEndpointProducerBuilder {
        default AdvancedServerEndpointBuilder advanced() {
            return (AdvancedServerEndpointBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder dataModuleOptions(
                org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataModuleOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder dataModuleOptions(String dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param filterNonExecute the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder filterNonExecute(boolean filterNonExecute) {
            doSetProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param filterNonExecute the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder filterNonExecute(String filterNonExecute) {
            doSetProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder protocolOptions(
                org.eclipse.neoscada.protocol.iec60870.ProtocolOptions protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ProtocolOptions&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param protocolOptions the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder protocolOptions(String protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder acknowledgeWindow(short acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 10
         * Group: connection
         * 
         * @param acknowledgeWindow the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder acknowledgeWindow(String acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder adsuAddressType(
                org.eclipse.neoscada.protocol.iec60870.ASDUAddressType adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.ASDUAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param adsuAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder adsuAddressType(String adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder causeOfTransmissionType(
                org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param causeOfTransmissionType the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder informationObjectAddressType(
                org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType&lt;/code&gt; type.
         * 
         * Group: connection
         * 
         * @param informationObjectAddressType the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder maxUnacknowledged(short maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 15
         * Group: connection
         * 
         * @param maxUnacknowledged the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder maxUnacknowledged(String maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder timeout1(int timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 15000
         * Group: connection
         * 
         * @param timeout1 the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder timeout1(String timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder timeout2(int timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: connection
         * 
         * @param timeout2 the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder timeout2(String timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder timeout3(int timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: connection
         * 
         * @param timeout3 the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder timeout3(String timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder causeSourceAddress(byte causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a &lt;code&gt;byte&lt;/code&gt; type.
         * 
         * Group: data
         * 
         * @param causeSourceAddress the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder causeSourceAddress(
                String causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder connectionTimeout(int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Timeout in millis to wait for client to establish a connected
         * connection.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: data
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder connectionTimeout(String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: data
         * 
         * @param ignoreBackgroundScan the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: data
         * 
         * @param ignoreDaylightSavingTime the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder timeZone(TimeZone timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.TimeZone&lt;/code&gt; type.
         * 
         * Default: UTC
         * Group: data
         * 
         * @param timeZone the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder timeZone(String timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: id
         * 
         * @param connectionId the value to set
         * @return the dsl builder
         */
        default ServerEndpointBuilder connectionId(String connectionId) {
            doSetProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IEC 60870 Server component.
     */
    public interface AdvancedServerEndpointBuilder
            extends
                AdvancedServerEndpointConsumerBuilder,
                AdvancedServerEndpointProducerBuilder {
        default ServerEndpointBuilder basic() {
            return (ServerEndpointBuilder) this;
        }
    }

    public interface ServerBuilders {
        /**
         * IEC 60870 Server (camel-iec60870)
         * IEC 60870 supervisory control and data acquisition (SCADA) server
         * using NeoSCADA implementation.
         * 
         * Category: iot
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-iec60870
         * 
         * @return the dsl builder for the headers' name.
         */
        default ServerHeaderNameBuilder iec60870Server() {
            return ServerHeaderNameBuilder.INSTANCE;
        }
        /**
         * IEC 60870 Server (camel-iec60870)
         * IEC 60870 supervisory control and data acquisition (SCADA) server
         * using NeoSCADA implementation.
         * 
         * Category: iot
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-iec60870
         * 
         * Syntax: <code>iec60870-server:uriPath</code>
         * 
         * Path parameter: uriPath (required)
         * The object information address
         * 
         * @param path uriPath
         * @return the dsl builder
         */
        default ServerEndpointBuilder iec60870Server(String path) {
            return ServerEndpointBuilderFactory.endpointBuilder("iec60870-server", path);
        }
        /**
         * IEC 60870 Server (camel-iec60870)
         * IEC 60870 supervisory control and data acquisition (SCADA) server
         * using NeoSCADA implementation.
         * 
         * Category: iot
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-iec60870
         * 
         * Syntax: <code>iec60870-server:uriPath</code>
         * 
         * Path parameter: uriPath (required)
         * The object information address
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path uriPath
         * @return the dsl builder
         */
        default ServerEndpointBuilder iec60870Server(
                String componentName,
                String path) {
            return ServerEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the IEC 60870 Server component.
     */
    public static class ServerHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final ServerHeaderNameBuilder INSTANCE = new ServerHeaderNameBuilder();

        /**
         * The address as ObjectAddress.
         * 
         * The option is a: {@code
         * org.apache.camel.component.iec60870.ObjectAddress} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code address}.
         */
        public String address() {
            return "address";
        }

        /**
         * The value.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code value}.
         */
        public String value() {
            return "value";
        }

        /**
         * The address as InformationObjectAddress.
         * 
         * The option is a: {@code
         * org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code informationObjectAddress}.
         */
        public String informationObjectAddress() {
            return "informationObjectAddress";
        }

        /**
         * The ASDU header.
         * 
         * The option is a: {@code
         * org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code asduHeader}.
         */
        public String asduHeader() {
            return "asduHeader";
        }

        /**
         * The type.
         * 
         * The option is a: {@code byte} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code type}.
         */
        public String type() {
            return "type";
        }

        /**
         * Is execute.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code execute}.
         */
        public String execute() {
            return "execute";
        }
    }
    static ServerEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class ServerEndpointBuilderImpl extends AbstractEndpointBuilder implements ServerEndpointBuilder, AdvancedServerEndpointBuilder {
            public ServerEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new ServerEndpointBuilderImpl(path);
    }
}