/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.torchserve.springboot;

import org.apache.camel.component.torchserve.TorchServeConfiguration;
import org.apache.camel.component.torchserve.client.model.RegisterOptions;
import org.apache.camel.component.torchserve.client.model.ScaleWorkerOptions;
import org.apache.camel.component.torchserve.client.model.UnregisterOptions;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Provide access to PyTorch TorchServe servers to run inference with PyTorch
 * models remotely
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.torchserve")
public class TorchServeComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the torchserve component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * The configuration. The option is a
     * org.apache.camel.component.torchserve.TorchServeConfiguration type.
     */
    private TorchServeConfiguration configuration;
    /**
     * The name of model.
     */
    private String modelName;
    /**
     * The version of model.
     */
    private String modelVersion;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * Used for enabling or disabling all consumer based health checks from this
     * component
     */
    private Boolean healthCheckConsumerEnabled = true;
    /**
     * Used for enabling or disabling all producer based health checks from this
     * component. Notice: Camel has by default disabled all producer based
     * health-checks. You can turn on producer checks globally by setting
     * camel.health.producersEnabled=true.
     */
    private Boolean healthCheckProducerEnabled = true;
    /**
     * The address of the inference API endpoint.
     */
    private String inferenceAddress;
    /**
     * The port of the inference API endpoint.
     */
    private Integer inferencePort = 8080;
    /**
     * The maximum number of items to return for the list operation. When this
     * value is present, TorchServe does not return more than the specified
     * number of items, but it might return fewer. This value is optional. If
     * you include a value, it must be between 1 and 1000, inclusive. If you do
     * not include a value, it defaults to 100.
     */
    private Integer listLimit = 100;
    /**
     * The token to retrieve the next set of results for the list operation.
     * TorchServe provides the token when the response from a previous call has
     * more results than the maximum page size.
     */
    private String listNextPageToken;
    /**
     * The address of the management API endpoint.
     */
    private String managementAddress;
    /**
     * The port of the management API endpoint.
     */
    private Integer managementPort = 8081;
    /**
     * Additional options for the register operation. The option is a
     * org.apache.camel.component.torchserve.client.model.RegisterOptions type.
     */
    private RegisterOptions registerOptions;
    /**
     * Additional options for the scale-worker operation. The option is a
     * org.apache.camel.component.torchserve.client.model.ScaleWorkerOptions
     * type.
     */
    private ScaleWorkerOptions scaleWorkerOptions;
    /**
     * Additional options for the unregister operation. The option is a
     * org.apache.camel.component.torchserve.client.model.UnregisterOptions
     * type.
     */
    private UnregisterOptions unregisterOptions;
    /**
     * Model archive download url, support local file or HTTP(s) protocol. For
     * S3, consider using pre-signed url.
     */
    private String url;
    /**
     * The address of the metrics API endpoint.
     */
    private String metricsAddress;
    /**
     * Names of metrics to filter.
     */
    private String metricsName;
    /**
     * The port of the metrics API endpoint.
     */
    private Integer metricsPort = 8082;
    /**
     * The token authorization key for accessing the inference API.
     */
    private String inferenceKey;
    /**
     * The token authorization key for accessing the management API.
     */
    private String managementKey;

    public TorchServeConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(TorchServeConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelVersion() {
        return modelVersion;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public Boolean getHealthCheckConsumerEnabled() {
        return healthCheckConsumerEnabled;
    }

    public void setHealthCheckConsumerEnabled(Boolean healthCheckConsumerEnabled) {
        this.healthCheckConsumerEnabled = healthCheckConsumerEnabled;
    }

    public Boolean getHealthCheckProducerEnabled() {
        return healthCheckProducerEnabled;
    }

    public void setHealthCheckProducerEnabled(Boolean healthCheckProducerEnabled) {
        this.healthCheckProducerEnabled = healthCheckProducerEnabled;
    }

    public String getInferenceAddress() {
        return inferenceAddress;
    }

    public void setInferenceAddress(String inferenceAddress) {
        this.inferenceAddress = inferenceAddress;
    }

    public Integer getInferencePort() {
        return inferencePort;
    }

    public void setInferencePort(Integer inferencePort) {
        this.inferencePort = inferencePort;
    }

    public Integer getListLimit() {
        return listLimit;
    }

    public void setListLimit(Integer listLimit) {
        this.listLimit = listLimit;
    }

    public String getListNextPageToken() {
        return listNextPageToken;
    }

    public void setListNextPageToken(String listNextPageToken) {
        this.listNextPageToken = listNextPageToken;
    }

    public String getManagementAddress() {
        return managementAddress;
    }

    public void setManagementAddress(String managementAddress) {
        this.managementAddress = managementAddress;
    }

    public Integer getManagementPort() {
        return managementPort;
    }

    public void setManagementPort(Integer managementPort) {
        this.managementPort = managementPort;
    }

    public RegisterOptions getRegisterOptions() {
        return registerOptions;
    }

    public void setRegisterOptions(RegisterOptions registerOptions) {
        this.registerOptions = registerOptions;
    }

    public ScaleWorkerOptions getScaleWorkerOptions() {
        return scaleWorkerOptions;
    }

    public void setScaleWorkerOptions(ScaleWorkerOptions scaleWorkerOptions) {
        this.scaleWorkerOptions = scaleWorkerOptions;
    }

    public UnregisterOptions getUnregisterOptions() {
        return unregisterOptions;
    }

    public void setUnregisterOptions(UnregisterOptions unregisterOptions) {
        this.unregisterOptions = unregisterOptions;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMetricsAddress() {
        return metricsAddress;
    }

    public void setMetricsAddress(String metricsAddress) {
        this.metricsAddress = metricsAddress;
    }

    public String getMetricsName() {
        return metricsName;
    }

    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    public Integer getMetricsPort() {
        return metricsPort;
    }

    public void setMetricsPort(Integer metricsPort) {
        this.metricsPort = metricsPort;
    }

    public String getInferenceKey() {
        return inferenceKey;
    }

    public void setInferenceKey(String inferenceKey) {
        this.inferenceKey = inferenceKey;
    }

    public String getManagementKey() {
        return managementKey;
    }

    public void setManagementKey(String managementKey) {
        this.managementKey = managementKey;
    }
}