/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.spring.boot.dummy;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.support.DefaultConsumer;

public class DummyConsumer extends DefaultConsumer {

    private boolean failOnRestart = true;

    public DummyConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    public DummyEndpoint getEndpoint() {
        return (DummyEndpoint) super.getEndpoint();
    }

    public boolean isFailOnRestart() {
        return failOnRestart;
    }

    public void setFailOnRestart(boolean failOnRestart) {
        this.failOnRestart = failOnRestart;
    }

    @Override
    protected void doStart() throws Exception {
        int counter = getEndpoint().getComponent().increment();
        if (counter == 2) {
            throw new IOException("Forced error on restart");
        }
        super.doStart();
    }
}
