/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.redhat.camel.component.cics.springboot;

import com.redhat.camel.component.cics.CICSConfiguration;
import com.redhat.camel.component.cics.CICSEciBinding;
import com.redhat.camel.component.cics.pool.CICSGatewayFactory;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * CICS Endpoint
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.cics")
public class CICSComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the cics component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * The Binding instance to transform a Camel Exchange to EciRequest and vice
     * versa. The option is a com.redhat.camel.component.cics.CICSEciBinding
     * type.
     */
    private CICSEciBinding binding;
    /**
     * Configuration. The option is a
     * com.redhat.camel.component.cics.CICSConfiguration type.
     */
    private CICSConfiguration configuration;
    /**
     * Enable debug mode on the underlying IBM CGT client.
     */
    private Boolean ctgDebug = false;
    /**
     * The ECI timeout value associated with this ECIRequest object. An ECI
     * timeout value of zero indicates that this ECIRequest will not be timed
     * out by CICS Transaction Gateway. An ECI timeout value greater than zero
     * indicates that the ECIRequest may be timed out by CICS Transaction
     * Gateway. ECI timeout can expire before a response is received from CICS.
     * This means that the client does not receive the confirmation from CICS
     * that a unit of work has been backed out or committed.
     */
    private Short eciTimeout = 0;
    /**
     * The transfer encoding of the message.
     */
    private String encoding = "Cp1145";
    /**
     * The connection factory to be use. The option is a
     * com.redhat.camel.component.cics.pool.CICSGatewayFactory type.
     */
    private CICSGatewayFactory gatewayFactory;
    /**
     * The address of the CICS Transaction Gateway that this instance connects
     * to
     */
    private String host;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * The port of the CICS Transaction Gateway that this instance connects to.
     */
    private Integer port = 2006;
    /**
     * the protocol that this component will use to connect to the CICS
     * Transaction Gateway.
     */
    private String protocol = "tcp";
    /**
     * The address of the CICS server that this instance connects to
     */
    private String server;
    /**
     * The full classname of the SSL key ring class or keystore file to be used
     * for the client encrypted connection
     */
    private String sslKeyring;
    /**
     * The password for the encrypted key ring class or keystore
     */
    private String sslPassword;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * The socket connection timeout
     */
    private Integer socketConnectionTimeout = 0;
    /**
     * Password to use for authentication
     */
    private String password;
    /**
     * User ID to use for authentication
     */
    private String userId;

    public CICSEciBinding getBinding() {
        return binding;
    }

    public void setBinding(CICSEciBinding binding) {
        this.binding = binding;
    }

    public CICSConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(CICSConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getCtgDebug() {
        return ctgDebug;
    }

    public void setCtgDebug(Boolean ctgDebug) {
        this.ctgDebug = ctgDebug;
    }

    public Short getEciTimeout() {
        return eciTimeout;
    }

    public void setEciTimeout(Short eciTimeout) {
        this.eciTimeout = eciTimeout;
    }

    public String getEncoding() {
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public CICSGatewayFactory getGatewayFactory() {
        return gatewayFactory;
    }

    public void setGatewayFactory(CICSGatewayFactory gatewayFactory) {
        this.gatewayFactory = gatewayFactory;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getServer() {
        return server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getSslKeyring() {
        return sslKeyring;
    }

    public void setSslKeyring(String sslKeyring) {
        this.sslKeyring = sslKeyring;
    }

    public String getSslPassword() {
        return sslPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public Integer getSocketConnectionTimeout() {
        return socketConnectionTimeout;
    }

    public void setSocketConnectionTimeout(Integer socketConnectionTimeout) {
        this.socketConnectionTimeout = socketConnectionTimeout;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}