/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.google.pubsublite.springboot;

import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Send and receive messages to/from Google Cloud Platform PubSub Lite Service.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.google-pubsub-lite")
public class GooglePubsubLiteComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the google-pubsub-lite component.
     * This is enabled by default.
     */
    private Boolean enabled;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions (if possible) occurred while the Camel consumer
     * is trying to pickup incoming messages, or the likes, will now be
     * processed as a message and handled by the routing Error Handler.
     * Important: This is only possible if the 3rd party component allows Camel
     * to be alerted if an exception was thrown. Some components handle this
     * internally only, and therefore bridgeErrorHandler is not possible. In
     * other situations we may improve the Camel component to hook into the 3rd
     * party component and make this possible for future releases. By default
     * the consumer will use the org.apache.camel.spi.ExceptionHandler to deal
     * with exceptions, that will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * The number of quota bytes that may be outstanding to the client. Must be
     * greater than the allowed size of the largest message (1 MiB).
     */
    private Long consumerBytesOutstanding = 10485760L;
    /**
     * The number of messages that may be outstanding to the client. Must be 0.
     */
    private Long consumerMessagesOutstanding = 1000L;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Maximum number of producers to cache. This could be increased if you have
     * producers for lots of different topics.
     */
    private Integer publisherCacheSize = 100;
    /**
     * How many milliseconds should each producer stay alive in the cache.
     */
    private Integer publisherCacheTimeout = 180000;
    /**
     * How many milliseconds should a producer be allowed to terminate.
     */
    private Integer publisherTerminationTimeout = 60000;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * The Service account key that can be used as credentials for the PubSub
     * Lite publisher/subscriber. It can be loaded by default from classpath,
     * but you can prefix with classpath:, file:, or http: to load the resource
     * from different systems.
     */
    private String serviceAccountKey;

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public Long getConsumerBytesOutstanding() {
        return consumerBytesOutstanding;
    }

    public void setConsumerBytesOutstanding(Long consumerBytesOutstanding) {
        this.consumerBytesOutstanding = consumerBytesOutstanding;
    }

    public Long getConsumerMessagesOutstanding() {
        return consumerMessagesOutstanding;
    }

    public void setConsumerMessagesOutstanding(Long consumerMessagesOutstanding) {
        this.consumerMessagesOutstanding = consumerMessagesOutstanding;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Integer getPublisherCacheSize() {
        return publisherCacheSize;
    }

    public void setPublisherCacheSize(Integer publisherCacheSize) {
        this.publisherCacheSize = publisherCacheSize;
    }

    public Integer getPublisherCacheTimeout() {
        return publisherCacheTimeout;
    }

    public void setPublisherCacheTimeout(Integer publisherCacheTimeout) {
        this.publisherCacheTimeout = publisherCacheTimeout;
    }

    public Integer getPublisherTerminationTimeout() {
        return publisherTerminationTimeout;
    }

    public void setPublisherTerminationTimeout(
            Integer publisherTerminationTimeout) {
        this.publisherTerminationTimeout = publisherTerminationTimeout;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public String getServiceAccountKey() {
        return serviceAccountKey;
    }

    public void setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
    }
}