/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.pqc.springboot;

import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Signature;
import javax.crypto.KeyGenerator;
import org.apache.camel.component.pqc.PQCConfiguration;
import org.apache.camel.component.pqc.PQCOperations;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Post Quantum Cryptography Signature and Verification component.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.pqc")
public class PQCComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the pqc component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * Component configuration. The option is a
     * org.apache.camel.component.pqc.PQCConfiguration type.
     */
    private PQCConfiguration configuration;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * The operation to perform
     */
    private PQCOperations operation;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * In case there is no keyGenerator, we specify an algorithm to build the
     * KeyGenerator
     */
    private String keyEncapsulationAlgorithm;
    /**
     * The Key Generator to be used in encapsulation and extraction. The option
     * is a javax.crypto.KeyGenerator type.
     */
    private KeyGenerator keyGenerator;
    /**
     * The KeyPair to be used. The option is a java.security.KeyPair type.
     */
    private KeyPair keyPair;
    /**
     * A KeyPair alias to use in combination with KeyStore parameter
     */
    private String keyPairAlias;
    /**
     * A KeyStore where we could get Cryptographic material. The option is a
     * java.security.KeyStore type.
     */
    private KeyStore keyStore;
    /**
     * The KeyStore password to use in combination with KeyStore Parameter
     */
    private String keyStorePassword;
    /**
     * In case there is no signer, we specify an algorithm to build the KeyPair
     * or the Signer
     */
    private String signatureAlgorithm;
    /**
     * The Signer to be used. The option is a java.security.Signature type.
     */
    private Signature signer;
    /**
     * In the context of extractSecretKeyFromEncapsulation operation, this
     * option define if we want to have the key set as header
     */
    private Boolean storeExtractedSecretKeyAsHeader = false;
    /**
     * In case we are using KEM operations, we need a Symmetric algorithm to be
     * defined for the flow to work.
     */
    private String symmetricKeyAlgorithm;
    /**
     * The required length of the symmetric key used
     */
    private Integer symmetricKeyLength = 128;
    /**
     * Used for enabling or disabling all consumer based health checks from this
     * component
     */
    private Boolean healthCheckConsumerEnabled = true;
    /**
     * Used for enabling or disabling all producer based health checks from this
     * component. Notice: Camel has by default disabled all producer based
     * health-checks. You can turn on producer checks globally by setting
     * camel.health.producersEnabled=true.
     */
    private Boolean healthCheckProducerEnabled = true;

    public PQCConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(PQCConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public PQCOperations getOperation() {
        return operation;
    }

    public void setOperation(PQCOperations operation) {
        this.operation = operation;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public String getKeyEncapsulationAlgorithm() {
        return keyEncapsulationAlgorithm;
    }

    public void setKeyEncapsulationAlgorithm(String keyEncapsulationAlgorithm) {
        this.keyEncapsulationAlgorithm = keyEncapsulationAlgorithm;
    }

    public KeyGenerator getKeyGenerator() {
        return keyGenerator;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public KeyPair getKeyPair() {
        return keyPair;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public String getKeyPairAlias() {
        return keyPairAlias;
    }

    public void setKeyPairAlias(String keyPairAlias) {
        this.keyPairAlias = keyPairAlias;
    }

    public KeyStore getKeyStore() {
        return keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getSignatureAlgorithm() {
        return signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public Signature getSigner() {
        return signer;
    }

    public void setSigner(Signature signer) {
        this.signer = signer;
    }

    public Boolean getStoreExtractedSecretKeyAsHeader() {
        return storeExtractedSecretKeyAsHeader;
    }

    public void setStoreExtractedSecretKeyAsHeader(
            Boolean storeExtractedSecretKeyAsHeader) {
        this.storeExtractedSecretKeyAsHeader = storeExtractedSecretKeyAsHeader;
    }

    public String getSymmetricKeyAlgorithm() {
        return symmetricKeyAlgorithm;
    }

    public void setSymmetricKeyAlgorithm(String symmetricKeyAlgorithm) {
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
    }

    public Integer getSymmetricKeyLength() {
        return symmetricKeyLength;
    }

    public void setSymmetricKeyLength(Integer symmetricKeyLength) {
        this.symmetricKeyLength = symmetricKeyLength;
    }

    public Boolean getHealthCheckConsumerEnabled() {
        return healthCheckConsumerEnabled;
    }

    public void setHealthCheckConsumerEnabled(Boolean healthCheckConsumerEnabled) {
        this.healthCheckConsumerEnabled = healthCheckConsumerEnabled;
    }

    public Boolean getHealthCheckProducerEnabled() {
        return healthCheckProducerEnabled;
    }

    public void setHealthCheckProducerEnabled(Boolean healthCheckProducerEnabled) {
        this.healthCheckProducerEnabled = healthCheckProducerEnabled;
    }
}