code# SAP Quick Starts  
**This directory contains a set of quick start projects to get you started with the suite of Red Hat build of Apache Camel SAP components.**  
![SAP Tool Suite](sap_tool_suite.png "SAP Tool Suite")

---

**Author:** William Collins - Fuse Team  
**Level:** Beginner to Advanced  
**Technologies:** SAP, Camel, Red Hat build of Apache Camel  
**Summary:** These quick starts demonstrate how to configure and use the suite of Red Hat build of Apache Camel SAP components to integrate Apache Camel with SAP.  
**Target Product:** Red Hat build of Apache Camel Spring Boot  
**Source:** <http://github.com/fusesource/sap-quickstarts/>

---  

## Overview

The Red Hat build of Apache Camel SAP quick starts are divided into two categories which demonstrate how to configure, deploy and run the Red Hat build of Apache Camel SAP components in different runtime environments.

### [Standalone](standalone/README.md)

The quick starts in this directory demonstrate how to configure, deploy and run the Red Hat build of Apache Camel SAP components in a standalone Camel container runtime.

### [Spring Boot](spring-boot/README.md)

The quick starts in this directory demonstrate how to configure, deploy and run the Red Hat build of Apache Camel SAP components in a Spring Boot Camel container runtime.

---

## Additional Resources

For more information see:

* [Red Hat build of Apache Camel SAP Component Starter](https://docs.redhat.com/en/documentation/red_hat_build_of_apache_camel/4.0/html/red_hat_build_of_apache_camel_for_spring_boot_reference/csb-camel-sap-component-starter) - Documentation for the Red Hat build of Apache Camel SAP components
* [Red Hat build of Apache Camel Documentation](https://docs.redhat.com/en/documentation/red_hat_build_of_apache_camel/4.10) - General documentation for using Red Hat build of Apache Camel

## System Requirements

To run these quick starts you will need:

* Maven 3.6.2 or higher
* JDK 11 or higher
* Red Hat build of Apache Camel Spring Boot
* SAP JCo3 and IDoc3 libraries (sapjco3.jar, sapidoc3.jar and JCo native library for your OS platform)
* SAP instance with [Flight Data Application](http://help.sap.com/saphelp_erp60_sp/helpdata/en/db/7c623cf568896be10000000a11405a/content.htm) setup
