/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.gson.springboot;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.apache.camel.test.spring.junit5.CamelSpringBootTest;

@DirtiesContext
@CamelSpringBootTest
@SpringBootTest(classes = { CamelAutoConfiguration.class, SpringGsonUnmarshalTypeFromHeaderTest.class }, properties = {
        "camel.main.routes-include-pattern=file:src/test/resources/routes/SpringGsonUnmarshalTypeFromHeaderTest.xml" }

)
public class SpringGsonUnmarshalTypeFromHeaderTest {

    @Autowired
    ProducerTemplate template;

    @Test
    public void testUnmarshalTypeFromHeader() {
        TestPojo pojo = template.requestBody("direct:springUnmarshalTypeFromHeader", "{\"name\":\"my-name\"}",
                TestPojo.class);
        assertNotNull(pojo);
        assertEquals("my-name", pojo.getName());
    }

}
