/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.language.xtokenizer.springboot;

import java.util.List;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.spring.boot.LanguageConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Tokenize XML payloads.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.language.xtokenize")
public class XMLTokenizeLanguageConfiguration
        extends
            LanguageConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the xtokenize language. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * The extraction mode. The available extraction modes are: i - injecting
     * the contextual namespace bindings into the extracted token (default) w -
     * wrapping the extracted token in its ancestor context u - unwrapping the
     * extracted token to its child content t - extracting the text content of
     * the specified element
     */
    private String mode = "i";
    /**
     * Injects the XML Namespaces of prefix - uri mappings
     */
    private List<PropertyDefinition> namespace;
    /**
     * Source to use, instead of message body. You can prefix with variable:,
     * header:, or property: to specify kind of source. Otherwise, the source is
     * assumed to be a variable. Use empty or null to use default source, which
     * is the message body.
     */
    private String source;
    /**
     * Whether to trim the value to remove leading and trailing whitespaces and
     * line breaks
     */
    private Boolean trim = true;

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<PropertyDefinition> getNamespace() {
        return namespace;
    }

    public void setNamespace(List<PropertyDefinition> namespace) {
        this.namespace = namespace;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Boolean getTrim() {
        return trim;
    }

    public void setTrim(Boolean trim) {
        this.trim = trim;
    }
}