DROP TABLE  IF EXISTS  APPROVAL CASCADE ;
CREATE TABLE APPROVAL
(
    APPROVED      BOOLEAN,
    APPROVAL_DATE TIMESTAMP,
    EXPENSE_ID    BIGINT,
    ID            BIGINT NOT NULL,
    APPROVER      CHARACTER VARYING(255),
    PRIMARY KEY (ID),
    UNIQUE (EXPENSE_ID)
);

DROP TABLE IF EXISTS EXPENSE CASCADE ;
CREATE TABLE EXPENSE
(
    APPROVAL_ID BIGINT,
    ID          BIGINT NOT NULL,
    DESCRIPTION CHARACTER VARYING(255),
    NAME        CHARACTER VARYING(255),
    PRIMARY KEY (ID),
    UNIQUE (APPROVAL_ID)
);

DROP TABLE IF EXISTS INVOICE CASCADE;
CREATE TABLE INVOICE
(
    AMOUNT      NUMERIC(38, 2),
    DATE        TIMESTAMP,
    EXPENSE_ID  BIGINT,
    ID          BIGINT NOT NULL,
    CURRENCY    CHARACTER VARYING(255),
    DESCRIPTION CHARACTER VARYING(255),
    PRIMARY KEY (ID)
);

