#!/usr/bin/bash

#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
set -euxo pipefail

WORKING=$(pwd)

#region libwebsockets
cmake -S "$REMOTE_SOURCES_DIR/libwebsockets/app" -B "$WORKING/lws_build" \
  -DLWS_LINK_TESTAPPS_DYNAMIC=ON \
  -DLWS_WITH_LIBUV=OFF \
  -DLWS_WITHOUT_BUILTIN_GETIFADDRS=ON \
  -DLWS_USE_BUNDLED_ZLIB=OFF \
  -DLWS_WITHOUT_BUILTIN_SHA1=ON \
  -DLWS_WITH_STATIC=OFF \
  -DLWS_IPV6=ON \
  -DLWS_WITH_HTTP2=OFF \
  -DLWS_WITHOUT_CLIENT=OFF \
  -DLWS_WITHOUT_SERVER=OFF \
  -DLWS_WITHOUT_TESTAPPS=ON \
  -DLWS_WITHOUT_TEST_SERVER=ON \
  -DLWS_WITHOUT_TEST_SERVER_EXTPOLL=ON \
  -DLWS_WITHOUT_TEST_PING=ON \
  -DLWS_WITHOUT_TEST_CLIENT=ON
cmake --build "$WORKING/lws_build" --parallel "$(nproc)" --verbose
cmake --install "$WORKING/lws_build"

DESTDIR=$WORKING/lws_install cmake --install "$WORKING/lws_build"
tar -z -C $WORKING/lws_install -cf /libwebsockets-image.tar.gz usr
#endregion

#region qpid-proton and skupper-router
do_patch () {
    PATCH_DIR=$1
    PATCH_SRC=$2
    if [ -d "${PATCH_DIR}" ]
    then
        for patch in $(find ${PATCH_DIR} -type f -name "*.patch"); do
            echo Applying patch ${patch}
            patch -f -d "${PATCH_SRC}" -p1 < $patch
        done;
    fi
}

do_patch "patches/proton" $REMOTE_SOURCES_DIR/proton/app

do_build () {
  local suffix=${1}
  local runtime_check=${2}

  cmake -S "$REMOTE_SOURCES_DIR/proton/app" -B "$WORKING/proton_build${suffix}" \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DRUNTIME_CHECK="${runtime_check}" \
    -DENABLE_LINKTIME_OPTIMIZATION=ON \
    -DCMAKE_POLICY_DEFAULT_CMP0069=NEW -DCMAKE_INTERPROCEDURAL_OPTIMIZATION=ON \
    -DBUILD_TLS=ON -DSSL_IMPL=openssl -DBUILD_STATIC_LIBS=ON -DBUILD_BINDINGS=python -DSYSINSTALL_PYTHON=ON \
    -DBUILD_EXAMPLES=OFF -DBUILD_TESTING=OFF \
    -DCMAKE_INSTALL_PREFIX=/usr
  cmake --build "proton_build${suffix}" --parallel "$(nproc)" --verbose
  DESTDIR="$WORKING/proton_install${suffix}" cmake --install "proton_build${suffix}"

  cmake -S "$REMOTE_SOURCES_DIR/skupper-router/app" -B "$WORKING/build${suffix}" \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DRUNTIME_CHECK="${runtime_check}" \
    -DCMAKE_INTERPROCEDURAL_OPTIMIZATION=ON \
    -DProton_USE_STATIC_LIBS=ON -DUSE_LIBWEBSOCKETS=ON -DUSE_LIBNGHTTP2=ON \
    -DProton_DIR="$WORKING/proton_install${suffix}/usr/lib64/cmake/Proton" \
    -DBUILD_TESTING=OFF \
    -DVERSION="${VERSION}" \
    -DCMAKE_INSTALL_PREFIX=/usr
  cmake --build "$WORKING/build${suffix}" --parallel "$(nproc)" --verbose
}

do_build "" OFF
do_build "_asan" asan

tar -z -C $WORKING/proton_install -cf /qpid-proton-image.tar.gz usr

DESTDIR=$WORKING/staging/ cmake --install $WORKING/build
cp "$WORKING/build_asan/router/skrouterd" "$WORKING/staging/usr/sbin/skrouterd_asan"
cp --target-directory="$WORKING/staging/" "$REMOTE_SOURCES_DIR/skupper-router/app/tests/tsan.supp" "$WORKING/build_asan/tests/lsan.supp"
tar -z -C $WORKING/staging/ -cf /skupper-router-image.tar.gz usr etc lsan.supp tsan.supp
#endregion
