/*
 * Copyright 2022 Red Hat
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.apicurio.registry.examples.references.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class Qualification {

    @JsonProperty("subject_name")
    private String subjectName;

    @JsonProperty("qualification")
    private int qualification;

    public Qualification() {
    }

    public Qualification(String subjectName, int qualification) {
        this.subjectName = subjectName;
        this.qualification = qualification;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public int getQualification() {
        return qualification;
    }

    public void setQualification(int qualification) {
        this.qualification = qualification;
    }

    @Override
    public String toString() {
        return "Qualification{" +
                "subjectName='" + subjectName + '\'' +
                ", qualification=" + qualification +
                '}';
    }
}
