/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.milyn.assertion.AssertArgument;
import org.milyn.container.ExecutionContext;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.javabean.lifecycle.BeanLifecycleObserver;
import org.milyn.javabean.lifecycle.BeanRepositoryLifecycleEvent;
import org.milyn.javabean.lifecycle.BeanRepositoryLifecycleObserver;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanRepositoryManager;

public class BeanLifecycleSubject {
    private final ArrayList<ObserverContext> observers = new ArrayList();
    private final BeanLifecycle beanLifecycle;
    private final BeanId beanId;
    private final ExecutionContext executionContext;

    public BeanLifecycleSubject(ExecutionContext executionContext, BeanLifecycle beanLifecycle, BeanId beanId) {
        AssertArgument.isNotNull(executionContext, "executionContext");
        AssertArgument.isNotNull((Object)beanLifecycle, "beanLifecycle");
        AssertArgument.isNotNull(beanId, "beanId");
        this.beanLifecycle = beanLifecycle;
        this.executionContext = executionContext;
        this.beanId = beanId;
    }

    @Deprecated
    public BeanLifecycleSubject(ExecutionContext executionContext, BeanLifecycle beanLifecycle, String beanId) {
        this(executionContext, beanLifecycle, BeanLifecycleSubject.getBeanId(executionContext, beanId));
    }

    @Deprecated
    public void addObserver(String observerId, boolean notifyOnce, BeanLifecycleObserver observer) {
        AssertArgument.isNotNullAndNotEmpty(observerId, "observerId");
        AssertArgument.isNotNull(observer, "observer");
        this.removeObserver(observerId);
        ObserverContext observerContext = new ObserverContext();
        observerContext.observerId = observerId;
        observerContext.observer = observer;
        observerContext.notifyOnce = notifyOnce;
        this.observers.add(observerContext);
    }

    public void addObserver(String observerId, boolean notifyOnce, BeanRepositoryLifecycleObserver observer) {
        AssertArgument.isNotNullAndNotEmpty(observerId, "observerId");
        AssertArgument.isNotNull(observer, "observer");
        this.removeObserver(observerId);
        ObserverContext observerContext = new ObserverContext();
        observerContext.observerId = observerId;
        observerContext.repositoryBeanLifecycleObserver = observer;
        observerContext.notifyOnce = notifyOnce;
        this.observers.add(observerContext);
    }

    public void removeObserver(String observerId) {
        AssertArgument.isNotNullAndNotEmpty(observerId, "observerId");
        boolean found = false;
        int i = 0;
        while (!found && i < this.observers.size()) {
            ObserverContext observerContext = this.observers.get(i);
            found = observerContext.observerId.equals(observerId);
            if (found) {
                this.observers.remove(i);
            }
            ++i;
        }
    }

    public void notifyObservers(Object bean) {
        if (this.observers.size() > 0) {
            List observersClone = (List)this.observers.clone();
            int i = 0;
            while (i < observersClone.size()) {
                ObserverContext observerContext = (ObserverContext)observersClone.get(i);
                if (observerContext.repositoryBeanLifecycleObserver != null) {
                    BeanRepositoryLifecycleEvent beanLifecycleEvent = new BeanRepositoryLifecycleEvent(this.executionContext, this.beanLifecycle, this.beanId, bean);
                    observerContext.repositoryBeanLifecycleObserver.onBeanLifecycleEvent(beanLifecycleEvent);
                } else {
                    observerContext.observer.onBeanLifecycleEvent(this.executionContext, this.beanLifecycle, this.beanId.getName(), bean);
                }
                if (observerContext.notifyOnce) {
                    this.removeObserver(observerContext.observerId);
                }
                ++i;
            }
        }
    }

    public BeanLifecycle getBeanLifecycle() {
        return this.beanLifecycle;
    }

    @Deprecated
    public String getBeanId() {
        return this.beanId.getName();
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    private static BeanId getBeanId(ExecutionContext executionContext, String beanId) {
        AssertArgument.isNotNullAndNotEmpty(beanId, "beanId");
        return BeanRepositoryManager.getInstance(executionContext.getContext()).getBeanIdRegister().getBeanId(beanId);
    }

    private class ObserverContext {
        String observerId;
        boolean notifyOnce = false;
        @Deprecated
        BeanLifecycleObserver observer;
        BeanRepositoryLifecycleObserver repositoryBeanLifecycleObserver;

        private ObserverContext() {
        }
    }
}

