/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.pojogen;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import org.milyn.assertion.AssertArgument;
import org.milyn.io.StreamUtils;
import org.milyn.javabean.pojogen.JMethod;
import org.milyn.javabean.pojogen.JNamedType;
import org.milyn.javabean.pojogen.JType;
import org.milyn.util.FreeMarkerTemplate;

public class JClass {
    private String packageName;
    private String className;
    private Class<?> skeletonClass;
    private List<JNamedType> properties = new ArrayList<JNamedType>();
    private List<JMethod> methods = new ArrayList<JMethod>();
    private boolean fluentSetters = true;
    private static FreeMarkerTemplate template;

    static {
        try {
            template = new FreeMarkerTemplate(StreamUtils.readStreamAsString(JClass.class.getResourceAsStream("JavaClass.ftl")));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load JavaClass.ftl FreeMarker template.", e);
        }
    }

    public JClass(String packageName, String className) {
        AssertArgument.isNotNull(packageName, "packageName");
        AssertArgument.isNotNull(className, "className");
        this.packageName = packageName;
        this.className = className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setFluentSetters(boolean fluentSetters) {
        this.fluentSetters = fluentSetters;
    }

    public Class<?> getSkeletonClass() {
        if (this.skeletonClass == null) {
            String skeletonClassName = String.valueOf(this.packageName) + "." + this.className;
            try {
                this.skeletonClass = Thread.currentThread().getContextClassLoader().loadClass(skeletonClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassPool pool = ClassPool.getDefault();
                CtClass cc = pool.makeClass(skeletonClassName);
                try {
                    this.skeletonClass = cc.toClass();
                }
                catch (CannotCompileException ee) {
                    throw new IllegalStateException("Unable to create runtime skeleton class for class '" + skeletonClassName + "'.", ee);
                }
            }
        }
        return this.skeletonClass;
    }

    public JClass addProperty(JNamedType property) {
        AssertArgument.isNotNull(property, "property");
        this.assertPropertyUndefined(property);
        this.properties.add(property);
        String propertyName = property.getName();
        String capitalizedPropertyName = String.valueOf(Character.toUpperCase(propertyName.charAt(0))) + propertyName.substring(1);
        JMethod getterMethod = new JMethod(property.getType(), "get" + capitalizedPropertyName);
        getterMethod.setBody("return " + property.getName() + ";");
        this.methods.add(getterMethod);
        if (this.fluentSetters) {
            JMethod setterMethod = new JMethod(new JType(this.getSkeletonClass()), "set" + capitalizedPropertyName);
            setterMethod.addParameter(property);
            setterMethod.setBody("this." + property.getName() + " = " + property.getName() + ";  return this;");
            this.methods.add(setterMethod);
        } else {
            JMethod setterMethod = new JMethod("set" + capitalizedPropertyName);
            setterMethod.addParameter(property);
            setterMethod.setBody("this." + property.getName() + " = " + property.getName() + ";");
            this.methods.add(setterMethod);
        }
        return this;
    }

    public List<JNamedType> getProperties() {
        return this.properties;
    }

    public List<JMethod> getMethods() {
        return this.methods;
    }

    public Set<Class<?>> getImports() {
        LinkedHashSet importSet = new LinkedHashSet();
        for (JNamedType property : this.properties) {
            property.getType().addImports(importSet, new String[]{"java.lang", this.packageName});
        }
        return importSet;
    }

    public void writeClass(Writer writer) throws IOException {
        HashMap<String, JClass> contextObj = new HashMap<String, JClass>();
        contextObj.put("class", this);
        writer.write(template.apply(contextObj));
    }

    private void assertPropertyUndefined(JNamedType property) {
        for (JNamedType definedProperty : this.properties) {
            if (!property.getName().equals(definedProperty.getName())) continue;
            throw new IllegalArgumentException("Property '" + property.getName() + "' already defined.");
        }
    }
}

