/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class CreateSessionMessage
extends PacketImpl {
    private String name;
    private long sessionChannelID;
    private int version;
    private String username;
    private String password;
    private int minLargeMessageSize;
    private boolean xa;
    private boolean autoCommitSends;
    private boolean autoCommitAcks;
    private boolean preAcknowledge;
    private int windowSize;
    private String defaultAddress;

    public CreateSessionMessage(String name, long sessionChannelID, int version, String username, String password, int minLargeMessageSize, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int windowSize, String defaultAddress) {
        super((byte)30);
        this.name = name;
        this.sessionChannelID = sessionChannelID;
        this.version = version;
        this.username = username;
        this.password = password;
        this.minLargeMessageSize = minLargeMessageSize;
        this.xa = xa;
        this.autoCommitSends = autoCommitSends;
        this.autoCommitAcks = autoCommitAcks;
        this.windowSize = windowSize;
        this.preAcknowledge = preAcknowledge;
        this.defaultAddress = defaultAddress;
    }

    public CreateSessionMessage() {
        super((byte)30);
    }

    public String getName() {
        return this.name;
    }

    public long getSessionChannelID() {
        return this.sessionChannelID;
    }

    public int getVersion() {
        return this.version;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isXA() {
        return this.xa;
    }

    public boolean isAutoCommitSends() {
        return this.autoCommitSends;
    }

    public boolean isAutoCommitAcks() {
        return this.autoCommitAcks;
    }

    public boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public String getDefaultAddress() {
        return this.defaultAddress;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeString(this.name);
        buffer.writeLong(this.sessionChannelID);
        buffer.writeInt(this.version);
        buffer.writeNullableString(this.username);
        buffer.writeNullableString(this.password);
        buffer.writeInt(this.minLargeMessageSize);
        buffer.writeBoolean(this.xa);
        buffer.writeBoolean(this.autoCommitSends);
        buffer.writeBoolean(this.autoCommitAcks);
        buffer.writeInt(this.windowSize);
        buffer.writeBoolean(this.preAcknowledge);
        buffer.writeNullableString(this.defaultAddress);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.name = buffer.readString();
        this.sessionChannelID = buffer.readLong();
        this.version = buffer.readInt();
        this.username = buffer.readNullableString();
        this.password = buffer.readNullableString();
        this.minLargeMessageSize = buffer.readInt();
        this.xa = buffer.readBoolean();
        this.autoCommitSends = buffer.readBoolean();
        this.autoCommitAcks = buffer.readBoolean();
        this.windowSize = buffer.readInt();
        this.preAcknowledge = buffer.readBoolean();
        this.defaultAddress = buffer.readNullableString();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CreateSessionMessage)) {
            return false;
        }
        CreateSessionMessage r = (CreateSessionMessage)other;
        boolean matches = super.equals(other) && this.name.equals(r.name) && this.sessionChannelID == r.sessionChannelID && this.version == r.version && this.xa == r.xa && this.autoCommitSends == r.autoCommitSends && this.autoCommitAcks == r.autoCommitAcks && (this.username == null ? r.username == null : this.username.equals(r.username)) && (this.password == null ? r.password == null : this.password.equals(r.password)) && (this.defaultAddress == null ? r.defaultAddress == null : this.defaultAddress.equals(r.defaultAddress));
        return matches;
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }
}

