package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.util.TomcatUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class TomcatModifyContext {
    private static AbstractUIProcessHandler mHandler;
    private static AutomatedInstallData idata;
    private static Map<String, String> resourceAttributeMap;

    static {
        resourceAttributeMap = new HashMap<>();
        resourceAttributeMap.put("name", "sharedDataSource");
        resourceAttributeMap.put("auth", "Container");
        resourceAttributeMap.put("type", "org.h2.jdbcx.JdbcDataSource");
        resourceAttributeMap.put("user", "sa");
        resourceAttributeMap.put("password", "sa");
        resourceAttributeMap.put("url", "jdbc:h2:mem:testdb;DB_CLOSE_DELAY=-1;MVCC=TRUE");
        resourceAttributeMap.put("description", "H2 Data Source");
        resourceAttributeMap.put("loginTimeout", "0");
        resourceAttributeMap.put("testOnBorrow", "false");
        resourceAttributeMap.put("factory", "org.h2.jdbcx.JdbcDataSourceFactory");
    }

    /**
     * Modifies the TOMCAT_HOME/conf/context.xml in accordance with kie-server's readme.
     *
     * @param handler message handler to communicate progress to the user.
     * @param args    unused for this job, but expected by izpack's reflection code
     * @return true upon success, false on some error
     */
    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        mHandler = handler;
        idata = AutomatedInstallData.getInstance();
        return configureTomcatContextFile();

    }

    /**
     * Modifies the /conf/context.xml of a tomcat installation to contain required changes for kie-server
     *
     * @return true if modifications to the context.xml were successful.
     */
    private static boolean configureTomcatContextFile() {
        try {
            Path tomcatContextPath = Paths.get(idata.getInstallPath() + "/conf/context.xml");
            Document xml = TomcatUtils.getXmlDocument(tomcatContextPath);
            xml.getDocumentElement().appendChild(xml.createComment(idata.langpack.getString("tomcat.installer.comment")));
            addResourceToContext(xml);
            TomcatUtils.writeXmlDocumentToFile(xml, tomcatContextPath);
        } catch (SAXException | ParserConfigurationException | IOException | TransformerException | XPathExpressionException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.contextfile.failed"), true);
            ProcessPanelHelper.printExceptionToLog(e.getStackTrace());
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.contextfile.success"), false);
        return true;
    }

    private static void addResourceToContext(Document xml) {
        Element resource = xml.createElement("Resource");
        for (Map.Entry<String, String> attr : resourceAttributeMap.entrySet()) {
            resource.setAttribute(attr.getKey(), attr.getValue());
        }
        xml.getDocumentElement().appendChild(resource);
    }
}
