package com.redhat.installer.installation.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;

import java.io.IOException;

/**
 * Created by eunderhi on 22/10/15.
 */
public class JarBinaryInPathValidator implements DataValidator {

    private static String warning = "cluster.demo.no.jar";

    @Override
    public Status validateData(AutomatedInstallData adata) {
        warning = adata.langpack.getString(warning);
        return executeCommand();
    }

    private Status executeCommand() {
        try {
            Runtime.getRuntime().exec("jar");
        }
        catch (IOException e) {
            return Status.WARNING;
        }
        return Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return warning;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return warning;
    }
}
