/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.lienzo.primitive;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.client.core.shape.wires.WiresShape;

public class WiresShapeDragProxy extends AbstractDragProxy<WiresShape> {

    public WiresShapeDragProxy(final Layer layer,
                               final WiresShape shape,
                               final int x,
                               final int y,
                               final int timeout,
                               final Callback callback) {
        super(layer,
              shape,
              x,
              y,
              timeout,
              callback);
    }

    @Override
    protected void addToLayer(final Layer layer,
                              final WiresShape shape) {
        getWiresManager(layer).register(shape);
        getWiresManager(layer).getMagnetManager().createMagnets(shape);
    }

    @Override
    protected void removeFromLayer(final Layer layer,
                                   final WiresShape shape) {
        getWiresManager(layer).deregister(shape);
    }

    @Override
    protected void setX(final WiresShape shape,
                        final int x) {
        shape.setX(x);
    }

    @Override
    protected void setY(final WiresShape shape,
                        final int y) {
        shape.setY(y);
    }

    protected WiresManager getWiresManager(final Layer layer) {
        return WiresManager.get(layer);
    }
}
