/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.ArrayList;
import java.util.Vector;
import oracle.net.jdbc.TNSAddress.Description;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.ConnectDescription;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavAddressList;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;

public class NavDescription
extends Description
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int descProcessed;
    private boolean done = false;

    public NavDescription(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        super(schemaObjectFactoryInterface);
    }

    @Override
    public void navigate(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        stringBuffer.append("(DESCRIPTION=");
        ConnectDescription connectDescription = connStrategy.newConnectDescription();
        try {
            if (this.SDU != null) {
                connStrategy.sdu = Integer.parseInt(this.SDU);
            }
            if (this.TDU != null) {
                connStrategy.tdu = Integer.parseInt(this.TDU);
            }
            if (this.connectTimeout != null) {
                connStrategy.connectTimeout = Integer.parseInt(this.connectTimeout) * 1000;
            }
            if (this.retryCount != null) {
                connStrategy.retryCount = Integer.parseInt(this.retryCount);
                connectDescription.setRetryCount(connStrategy.retryCount);
            }
            if (this.delay != -1) {
                connectDescription.setDelayInMillis(this.delay * 1000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        connStrategy.addSocketOptions(this.keepAlive);
        if (this.sourceRoute) {
            if (!this.backwardCompatibilityCase(this.children, connStrategy)) {
                this.activeChildren = this.children;
                ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(connStrategy, stringBuffer);
                for (int i2 = 1; i2 < this.activeChildren.size(); ++i2) {
                    ((NavSchemaObject)this.activeChildren.elementAt(i2)).addToString(connStrategy);
                }
            } else {
                this.setConnectionOption(connStrategy, stringBuffer);
            }
            this.closeNVPair(connStrategy);
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            for (int i3 = 0; i3 < this.activeChildren.size(); ++i3) {
                ((NavSchemaObject)this.activeChildren.elementAt(i3)).navigate(connStrategy, stringBuffer);
            }
            this.closeNVPair(connStrategy);
        }
        this.done = true;
        if (this.loadBalance) {
            connStrategy.addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF();
        }
        connStrategy.closeDescription();
    }

    public void closeNVPair(ConnStrategy connStrategy) {
        ArrayList<ConnOption> arrayList = connStrategy.currentDescription().getConnectOptions();
        for (int i2 = arrayList.size() - 1; i2 >= 0 && !arrayList.get((int)i2).done; --i2) {
            ConnOption connOption = arrayList.get(i2);
            if (this.sourceRoute) {
                connOption.conn_data.append("(SOURCE_ROUTE=yes)");
            }
            if (this.connectData == null) {
                this.connectData = "(SERVICE_NAME=)";
            }
            connOption.conn_data.append("(CONNECT_DATA=");
            connOption.conn_data.append("(CID=(PROGRAM=");
            connOption.conn_data.append(connStrategy.getProgramName());
            connOption.conn_data.append(")(HOST=__jdbc__)(USER=");
            connOption.conn_data.append(connStrategy.getOSUsername());
            connOption.conn_data.append("))");
            connOption.conn_data.append(this.connectData);
            connOption.conn_data.append(")");
            if (this.SID != null) {
                connOption.sid = this.SID;
            }
            if (this.serviceName != null) {
                connOption.service_name = this.serviceName;
            }
            if (this.instanceName != null) {
                connOption.instance_name = this.instanceName;
            }
            if (this.sslServerCertDN != null) {
                connOption.sslServerCertDN = this.sslServerCertDN;
            }
            connOption.conn_data.append(")");
            connOption.done = true;
        }
    }

    @Override
    public void addToString(ConnStrategy connStrategy) {
    }

    private boolean backwardCompatibilityCase(Vector vector, ConnStrategy connStrategy) {
        if (vector.size() == 1 && ((NavSchemaObject)vector.elementAt(0)).isA() == 1 && !((NavAddressList)vector.elementAt((int)0)).sourceRoute) {
            NavAddressList navAddressList = (NavAddressList)vector.elementAt(0);
            int n2 = navAddressList.getChildrenSize();
            if (n2 == 0) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (navAddressList.getChildrenType(i2) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void setConnectionOption(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        stringBuffer.append("(ADDRESS_LIST=");
        NavAddressList navAddressList = (NavAddressList)this.children.elementAt(0);
        NavAddress navAddress = navAddressList.getChild(0);
        int n2 = navAddressList.getChildrenSize();
        navAddress.navigate(connStrategy, stringBuffer);
        for (int i2 = 1; i2 < n2; ++i2) {
            navAddressList.getChild(i2).addToString(connStrategy);
        }
        connStrategy.currentDescription().getConnectOptions().get((int)0).conn_data.append(")");
    }
}

