/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.ConstantPool;
import com.claritysys.jvm.classfile.CpEntry;
import com.claritysys.jvm.classfile.CpUtf8;
import java.io.DataOutput;
import java.io.IOException;

public final class CpClass
extends CpEntry {
    CpUtf8 name;

    CpClass(ConstantPool cpool, int hash, CpUtf8 n) {
        super(cpool, (byte)7, hash);
        this.name = n;
    }

    public CpClass(ConstantPool pool) {
        super(pool, (byte)7, 0);
    }

    public final CpUtf8 getName() {
        return this.name;
    }

    public final String getStringName() {
        return this.name.string;
    }

    void write(DataOutput dstr) throws IOException {
        dstr.writeByte(7);
        dstr.writeShort(this.name.index);
    }

    public String toString() {
        return "Class:   " + this.name.getIndex();
    }

    static final int hashCode(CpUtf8 name) {
        return name.hashCode() ^ 0xF0F;
    }

    public void computeHash() {
        if (this.name.hash == 0) {
            this.name.computeHash();
        }
        this.hash = CpClass.hashCode(this.name);
    }

    void postClone() {
        super.postClone();
        this.name = (CpUtf8)this.pool.getPoolEntry(this.name.index);
    }
}

