/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.RequeueAware;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.kie.api.cluster.ClusterAwareService;
import org.kie.api.cluster.ClusterListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.jbpm.cluster.ClusteredJobFailOverListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPMClusterKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "jBPM-Cluster";
    private static final Logger logger = LoggerFactory.getLogger(JBPMClusterKieServerExtension.class);
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.kie.jbpm.cluster.server.ext.disabled", "false"));
    private static final Boolean jbpmDisabled = Boolean.parseBoolean(System.getProperty("org.jbpm.server.ext.disabled", "false"));
    private boolean initialized = false;
    private KieServerRegistry registry;
    private ExecutorService jbpmExecutorService;
    private ClusterAwareService clusterService;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return disabled == false && jbpmDisabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.registry = registry;
        KieServerExtension jbpmExtension = registry.getServerExtension("jBPM");
        if (jbpmExtension == null) {
            this.initialized = false;
            logger.warn("jBPM extension not found, jBPM Cluster cannot work without jBPM extension, disabling itself");
            return;
        }
        this.configureServices();
        ExecutorServiceImpl service = (ExecutorServiceImpl)this.jbpmExecutorService;
        ClusteredJobFailOverListener clusteredJobFailOverListener = new ClusteredJobFailOverListener(this.clusterService, (RequeueAware)service);
        service.addAsyncJobListener((AsynchronousJobListener)clusteredJobFailOverListener);
        this.clusterService.addClusterListener((ClusterListener)clusteredJobFailOverListener);
        this.initialized = true;
    }

    private void configureServices() {
        KieServerExtension jbpmExtension = this.registry.getServerExtension("jBPM");
        List jbpmServices = jbpmExtension.getServices();
        for (Object object : jbpmServices) {
            if (object == null || !ExecutorService.class.isAssignableFrom(object.getClass())) continue;
            this.jbpmExecutorService = (ExecutorService)object;
        }
        this.clusterService = (ClusterAwareService)ServiceRegistry.getService(ClusterAwareService.class);
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] services = new Object[]{this.clusterService};
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        Object[] services;
        for (Object service : services = new Object[]{this.clusterService}) {
            if (service == null || !serviceType.isAssignableFrom(service.getClass())) continue;
            return serviceType.cast(service);
        }
        return null;
    }

    public String getImplementedCapability() {
        return "BPM-Cluster";
    }

    public List<Object> getServices() {
        return Collections.singletonList(this.clusterService);
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 10;
    }

    public String toString() {
        return "jBPM-Cluster KIE Server extension";
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        if (report) {
            messages.add(new Message(Severity.INFO, this.getExtensionName() + " is alive"));
        }
        return messages;
    }
}

