package org.jboss.brmsbpmsuite.elytronmigration;

import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FilesystemRealmTransformerTest {

    static final URL realmUrl = FilesystemRealmTransformerTest.class.getResource("/elytron/kie-fs-realm");

    Path tempDirectory;

    @Before
    public void setup() throws IOException, URISyntaxException {
        tempDirectory = Files.createTempDirectory("kie-fs-realm");
        Path resourcesDirectory = Paths.get(realmUrl.toURI());
        FileUtils.copyDirectory(resourcesDirectory.toFile(), tempDirectory.toFile());
    }

    @Test
    public void shouldReplaceTheAttributeRoles() throws ParserConfigurationException, IOException, SAXException {
        FilesystemRealmTransformer transformer = new FilesystemRealmTransformer(tempDirectory);
        transformer.transform();

        Path aUserPath = Paths.get(tempDirectory.toAbsolutePath().toString(), "a/a-user.xml");
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document aUserDocument = documentBuilder.parse(aUserPath.toFile());

        NodeList attributes = aUserDocument.getElementsByTagName("attribute");
        Assert.assertEquals("role", attributes.item(0).getAttributes().getNamedItem("name").getNodeValue());
        Assert.assertEquals("role", attributes.item(1).getAttributes().getNamedItem("name").getNodeValue());
    }

    @Test
    public void shouldNotReplaceOtherAttributeValues() throws ParserConfigurationException, IOException, SAXException {
        FilesystemRealmTransformer transformer = new FilesystemRealmTransformer(tempDirectory);
        transformer.transform();

        Path zUserPath = Paths.get(tempDirectory.toAbsolutePath().toString(), "z/z-user.xml");
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document zUserDocument = documentBuilder.parse(zUserPath.toFile());

        NodeList attributes = zUserDocument.getElementsByTagName("attribute");
        Assert.assertEquals("other", attributes.item(0).getAttributes().getNamedItem("name").getNodeValue());
        Assert.assertEquals("roless", attributes.item(1).getAttributes().getNamedItem("name").getNodeValue());
    }
}
