/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.kie.api.cluster.ClusterAwareService;
import org.kie.api.cluster.ClusterListener;
import org.kie.api.cluster.ClusterNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Listener(observation=Listener.Observation.POST)
public class InfinispanClusterAwareService
implements ClusterAwareService {
    private static final Logger logger = LoggerFactory.getLogger(InfinispanClusterAwareService.class);
    private List<ClusterListener> listeners;
    private String kieServerId;
    private String kieServerLocation;
    private EmbeddedCacheManager cacheManager;

    public InfinispanClusterAwareService(String kieServerId, String kieServerLocation) {
        this.kieServerId = kieServerId;
        this.kieServerLocation = kieServerLocation;
        this.listeners = new ArrayList<ClusterListener>();
    }

    public InfinispanClusterAwareService() {
        this(System.getProperty("org.kie.server.id"), System.getProperty("org.kie.server.location"));
    }

    public ClusterNode getThisNode() {
        return new ClusterNode(this.kieServerId, this.kieServerLocation);
    }

    public void init(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        cacheManager.addListener((Object)this);
        Cache nodes = cacheManager.getCache("nodes");
        nodes.addListener((Object)this);
        logger.info("This node is about to join the jBPM cluster {}-{}", (Object)this.kieServerId, (Object)this.kieServerLocation);
        nodes.put((Object)cacheManager.getAddress(), (Object)this.getThisNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheEntryCreated
    public void nodeJoined(CacheEntryCreatedEvent<Address, ClusterNode> event) {
        if (!this.isCoordinator()) {
            return;
        }
        logger.info("jBPM cluster member joined {}", event.getValue());
        List<ClusterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.forEach(listener -> listener.nodeJoined((ClusterNode)event.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheEntryRemoved
    public void nodeLeft(CacheEntryRemovedEvent<Address, ClusterNode> event) {
        if (!this.isCoordinator()) {
            return;
        }
        logger.info("jBPM cluster member left {}", event.getOldValue());
        List<ClusterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.forEach(listener -> listener.nodeLeft((ClusterNode)event.getOldValue()));
        }
    }

    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        logger.info("jBPM cluster view changed. Current active nodes: {}", (Object)event.getNewMembers());
        if (Event.Type.VIEW_CHANGED.equals((Object)event.getType()) && this.isCoordinator()) {
            List changedAddress = event.getNewMembers();
            Cache nodes = this.cacheManager.getCache("nodes");
            CacheSet currentView = this.cacheManager.getCache("nodes").keySet();
            ArrayList<Address> membersLeft = new ArrayList<Address>();
            for (Address address : currentView) {
                if (changedAddress.contains(address)) continue;
                membersLeft.add(address);
            }
            membersLeft.forEach(node -> nodes.remove(node));
        }
    }

    public boolean isCoordinator() {
        return this.cacheManager.isCoordinator();
    }

    public Collection<ClusterNode> getActiveClusterNodes() {
        return this.cacheManager.getCache("nodes").values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void removeData(String key, String partition, T value) {
        if (!this.cacheManager.cacheExists(key)) {
            return;
        }
        Cache cache = this.cacheManager.getCache(key);
        InfinispanClusterAwareService infinispanClusterAwareService = this;
        synchronized (infinispanClusterAwareService) {
            ArrayList values = (ArrayList)cache.get((Object)partition);
            values = values == null ? new ArrayList() : new ArrayList(values);
            values.remove(value);
            cache.put((Object)partition, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addData(String key, String partition, T value) {
        if (!this.cacheManager.cacheExists(key)) {
            return;
        }
        Cache cache = this.cacheManager.getCache(key);
        InfinispanClusterAwareService infinispanClusterAwareService = this;
        synchronized (infinispanClusterAwareService) {
            ArrayList<T> values = (ArrayList<T>)cache.get((Object)partition);
            values = values == null ? new ArrayList<T>() : new ArrayList(values);
            values.add(value);
            cache.put((Object)partition, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getData(String key) {
        if (!this.cacheManager.cacheExists(key)) {
            return Collections.emptyList();
        }
        InfinispanClusterAwareService infinispanClusterAwareService = this;
        synchronized (infinispanClusterAwareService) {
            CacheCollection values = this.cacheManager.getCache(key).values();
            return (List)values.stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getDataFromPartition(String key, String partition) {
        if (!this.cacheManager.cacheExists(key)) {
            return Collections.emptyList();
        }
        InfinispanClusterAwareService infinispanClusterAwareService = this;
        synchronized (infinispanClusterAwareService) {
            List values = (List)this.cacheManager.getCache(key).get((Object)partition);
            return values == null ? Collections.emptyList() : values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterListener(ClusterListener listener) {
        List<ClusterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }
}

