#!/usr/bin/env bats

export JBOSS_HOME=$BATS_TMPDIR/jboss_home
mkdir -p $JBOSS_HOME/bin/launch
mkdir -p ${JBOSS_HOME}/standalone/deployments

cp $BATS_TEST_DIRNAME/../../../tests/bats/common/logging.bash $JBOSS_HOME/bin/launch/logging.sh

teardown() {
    rm -rf $JBOSS_HOME
}

# This test will perform a part of a s2i build which consists on receiv the jar generated by the mvn command
# then read it and install it on local maven repo, in the same way a usual s2i build would do.
@test "test if the maven instructions are successfully executed." {
    export DEPLOY_DIR="${JBOSS_HOME}/standalone/deployments"
    export LOCAL_SOURCE_DIR=/tmp/src
    # build the pom.xml
    cd $BATS_TEST_DIRNAME/resources/assembly-build
    mvn clean package
    cp target/assembly-build-rhpam-2274-1.0.0.jar ${DEPLOY_DIR}

    # script should return 0
    bash $BATS_TEST_DIRNAME/../../added/launch/kieserver-install.sh
    echo ${output}
    [ $? -eq 0 ]

    # no files are expected to be under deployments dir
    no_files_expected=$(ls ${DEPLOY_DIR} | wc -l)
    echo `ls -la ${DEPLOY_DIR}`
    [ $no_files_expected -eq 0 ]

    # files needs to be installed on local maven repository
    echo ${output}
    [ -f ~/.m2/repository/org/kie/kieserver/assembly-build-rhpam-2274/1.0.0/assembly-build-rhpam-2274-1.0.0.pom ]
    [ -f ~/.m2/repository/org/kie/kieserver/assembly-build-rhpam-2274/1.0.0/assembly-build-rhpam-2274-1.0.0.jar ]
    [ -f ~/.m2/repository/org/kie/kie-api/7.14.0.Final-redhat-00004/kie-api-7.14.0.Final-redhat-00004.pom ]
    [ -f ~/.m2/repository/org/kie/kie-internal/7.14.0.Final-redhat-00004/kie-internal-7.14.0.Final-redhat-00004.pom ]
    [ -f ~/.m2/repository/org/kie/soup/kie-soup-maven-support/7.14.0.Final-redhat-00004/kie-soup-maven-support-7.14.0.Final-redhat-00004.pom ]
    [ -f ~/.m2/repository/org/slf4j/slf4j-api/1.7.25/slf4j-api-1.7.25.pom ]
}

