/*
 * Copyright 2022 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 *
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.compiler.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GroupByDescr extends AccumulateDescr {
    private String groupingKey;
    private String groupingFunction;

    public String getGroupingFunction() {
        return groupingFunction;
    }

    public void setGroupingFunction(String groupingFunction) {
        this.groupingFunction = groupingFunction;
    }

    public String getGroupingKey() {
        return groupingKey;
    }

    public void setGroupingKey(String groupingKey) {
        this.groupingKey = groupingKey;
    }

    public void readExternal(ObjectInput in ) throws IOException, ClassNotFoundException {
        super.readExternal( in );
        groupingFunction = (String) in.readObject();
        groupingKey = (String) in.readObject();
    }

    public void writeExternal( ObjectOutput out ) throws IOException {
        super.writeExternal( out );
        out.writeObject( groupingFunction );
        out.writeObject( groupingKey );
    }
}
