/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.net.InetAddress;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class ConnectPacket
extends Packet
implements SQLnetDef {
    private boolean connDataOflow;
    private byte[] connBytes;

    public ConnectPacket(SessionAtts sessionAtts, boolean bl, boolean bl2) throws IOException {
        super(sessionAtts);
        this.data = sessionAtts.cOption.conn_data.toString();
        if (this.data != null) {
            this.data = ConnectPacket.makeConnectionStringUseIPAddresses(this.data, sessionAtts.nt.getInetAddress());
            this.connBytes = this.data.getBytes();
            this.dataLen = this.connBytes.length;
        } else {
            this.connBytes = null;
            this.dataLen = 0;
        }
        this.connDataOflow = this.dataLen > 230;
        int n2 = !this.connDataOflow ? 70 + this.dataLen : 70;
        this.createBuffer(n2, 1, sessionAtts.redirecting ? 2 : 0);
        sessionAtts.redirecting = false;
        this.buffer[8] = 1;
        this.buffer[9] = 59;
        this.buffer[10] = 1;
        this.buffer[11] = 44;
        int n3 = 1;
        if (bl && sessionAtts.nt.isCharacteristicUrgentSupported()) {
            n3 |= 0xC00;
        }
        if (bl2) {
            n3 |= 0x40;
        }
        this.buffer[12] = (byte)(n3 >> 8 & 0xFF);
        this.buffer[13] = (byte)(n3 & 0xFF);
        if (this.sdu < 65535) {
            this.buffer[14] = (byte)(this.sdu / 256);
            this.buffer[15] = (byte)(this.sdu % 256);
        } else {
            this.buffer[14] = -1;
            this.buffer[15] = -1;
        }
        if (this.tdu < 65535) {
            this.buffer[16] = (byte)(this.tdu / 256);
            this.buffer[17] = (byte)(this.tdu % 256);
        } else {
            this.buffer[16] = -1;
            this.buffer[17] = -1;
        }
        this.buffer[18] = 79;
        this.buffer[19] = -104;
        this.buffer[22] = 0;
        this.buffer[23] = 1;
        this.buffer[24] = (byte)(this.dataLen / 256);
        this.buffer[25] = (byte)(this.dataLen % 256);
        this.buffer[27] = 70;
        if (!sessionAtts.anoEnabled) {
            this.buffer[33] = 4;
            this.buffer[32] = 4;
        } else {
            this.buffer[32] = this.buffer[33] = (byte)sessionAtts.getANOFlags();
        }
        this.buffer[32] = (byte)(this.buffer[32] | 0x80);
        this.buffer[33] = (byte)(this.buffer[33] | 0x80);
        ConnectPacket.setUb2ToBytes(this.buffer, 50, 0);
        ConnectPacket.setUb2ToBytes(this.buffer, 52, 0);
        ConnectPacket.setUb2ToBytes(this.buffer, 54, 0);
        ConnectPacket.setUb2ToBytes(this.buffer, 56, 0);
        this.buffer[61] = (byte)(this.sdu & 0xFF);
        this.buffer[60] = (byte)(this.sdu >> 8 & 0xFF);
        this.buffer[59] = (byte)(this.sdu >> 16 & 0xFF);
        this.buffer[58] = (byte)(this.sdu >> 24 & 0xFF);
        this.buffer[65] = (byte)(this.tdu & 0xFF);
        this.buffer[64] = (byte)(this.tdu >> 8 & 0xFF);
        this.buffer[63] = (byte)(this.tdu >> 16 & 0xFF);
        this.buffer[62] = (byte)(this.tdu >> 24 & 0xFF);
        if (!this.connDataOflow && this.connBytes != null && this.connBytes.length > 0) {
            System.arraycopy(this.connBytes, 0, this.buffer, 70, this.connBytes.length);
        }
    }

    @Override
    protected void send() throws IOException {
        super.send();
        if (this.connDataOflow) {
            byte[] byArray = new byte[this.connBytes.length];
            System.arraycopy(this.connBytes, 0, byArray, 0, this.connBytes.length);
            this.sAtts.nsOutputStream.write(byArray);
            this.sAtts.nsOutputStream.flush();
        }
    }

    static final String makeConnectionStringUseIPAddresses(String string, InetAddress inetAddress) {
        String string2 = string;
        try {
            String string3;
            NVPair nVPair;
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair2 = new NVFactory().createNVPair(string);
            NVPair nVPair3 = null;
            NVPair nVPair4 = nVNavigator.findNVPair(nVPair2, "ADDRESS_LIST");
            nVPair3 = nVPair4 != null ? nVNavigator.findNVPair(nVPair4, "ADDRESS") : nVNavigator.findNVPair(nVPair2, "ADDRESS");
            if (nVPair3 != null && (nVPair = nVNavigator.findNVPair(nVPair3, "HOST")) != null && (string3 = nVPair.getAtom()) != null && !string3.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}") && !string3.matches("[\\[[\\w:]*\\]]") && inetAddress != null) {
                nVPair.setAtom(inetAddress.getHostAddress());
                string2 = nVPair2.toString();
            }
        }
        catch (NLException nLException) {
            // empty catch block
        }
        return string2;
    }
}

