package org.jboss.brmsbpmsuite.patching.client;

import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.junit.Test;

import java.io.File;

public class GeneralDistributionPatcherTest extends BaseClientPatcherTest {

    private File distroRoot = new File(tmpDir, "root-dir");
    private File backupDir = new File(tmpDir, "backup");
    private File patchDir = new File(tmpDir, "patched-files");

    @Before
    public void setup() throws Exception {
        super.setup();
        FileUtils.forceMkdir(distroRoot);
        FileUtils.copyDirectory(getCPResourceAsFile("/general-dir-patcher-test/root-dir"), distroRoot);

        FileUtils.forceMkdir(patchDir);
        FileUtils.copyDirectory(getCPResourceAsFile("/general-dir-patcher-test/patched-files"), patchDir);

        FileUtils.forceMkdir(backupDir);
    }

    @Test(expected = InvalidDistributionRootException.class)
    public void shouldFailWhenNonExistingDistributionRootSpecified() {
        DistributionPatcher patcher = new GeneralDistributionPatcher(new File("target/some/non-existing/path"),
                NOP_DISTRIBUTION_CHECKER, NOP_VERSION_CHECKER, null);
        patcher.checkDistro();
    }

    @Test
    public void shouldCorrectlyPerformWholeLifecycleWithEmptyLists() throws Exception {
        File distroRoot = new File(tmpDir, "root-dir");
        File backupDir = new File(tmpDir, "backup-dir");
        FileUtils.copyDirectory(getCPResourceAsFile("/general-dir-patcher-test/root-dir"), distroRoot);
        Patcher delegatePatcher = new DirectoryPatcher(distroRoot, EMPTY_STR_LIST, EMPTY_STR_LIST, EMPTY_PATCH_ENTRY_LIST, EMPTY_CHECKSUMS_MAP);
        GeneralDistributionPatcher patcher = new GeneralDistributionPatcher(distroRoot, NOP_DISTRIBUTION_CHECKER, NOP_VERSION_CHECKER, delegatePatcher);
        patcher.checkDistro();
        patcher.backup(backupDir);
        patcher.apply();
    }

}
