// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImagePullLibpodParams creates a new ImagePullLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImagePullLibpodParams() *ImagePullLibpodParams {
	return &ImagePullLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImagePullLibpodParamsWithTimeout creates a new ImagePullLibpodParams object
// with the ability to set a timeout on a request.
func NewImagePullLibpodParamsWithTimeout(timeout time.Duration) *ImagePullLibpodParams {
	return &ImagePullLibpodParams{
		timeout: timeout,
	}
}

// NewImagePullLibpodParamsWithContext creates a new ImagePullLibpodParams object
// with the ability to set a context for a request.
func NewImagePullLibpodParamsWithContext(ctx context.Context) *ImagePullLibpodParams {
	return &ImagePullLibpodParams{
		Context: ctx,
	}
}

// NewImagePullLibpodParamsWithHTTPClient creates a new ImagePullLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewImagePullLibpodParamsWithHTTPClient(client *http.Client) *ImagePullLibpodParams {
	return &ImagePullLibpodParams{
		HTTPClient: client,
	}
}

/*
ImagePullLibpodParams contains all the parameters to send to the API endpoint

	for the image pull libpod operation.

	Typically these are written to a http.Request.
*/
type ImagePullLibpodParams struct {

	/* Arch.

	   Pull image for the specified architecture.
	*/
	Arch *string

	/* OS.

	   Pull image for the specified operating system.
	*/
	OS *string

	/* Variant.

	   Pull image for the specified variant.
	*/
	Variant *string

	/* XRegistryAuth.

	   base-64 encoded auth config. Must include the following four values: username, password, email and server address OR simply just an identity token.
	*/
	XRegistryAuth *string

	/* AllTags.

	   Pull all tagged images in the repository.
	*/
	AllTags *bool

	/* Credentials.

	   username:password for the registry
	*/
	Credentials *string

	/* Policy.

	   Pull policy, "always" (default), "missing", "newer", "never".
	*/
	Policy *string

	/* Quiet.

	   silences extra stream data on pull
	*/
	Quiet *bool

	/* Reference.

	   Mandatory reference to the image (e.g., quay.io/image/name:tag)
	*/
	Reference *string

	/* TLSVerify.

	   Require TLS verification.

	   Default: true
	*/
	TLSVerify *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image pull libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImagePullLibpodParams) WithDefaults() *ImagePullLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image pull libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImagePullLibpodParams) SetDefaults() {
	var (
		quietDefault = bool(false)

		tLSVerifyDefault = bool(true)
	)

	val := ImagePullLibpodParams{
		Quiet:     &quietDefault,
		TLSVerify: &tLSVerifyDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the image pull libpod params
func (o *ImagePullLibpodParams) WithTimeout(timeout time.Duration) *ImagePullLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image pull libpod params
func (o *ImagePullLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image pull libpod params
func (o *ImagePullLibpodParams) WithContext(ctx context.Context) *ImagePullLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image pull libpod params
func (o *ImagePullLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image pull libpod params
func (o *ImagePullLibpodParams) WithHTTPClient(client *http.Client) *ImagePullLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image pull libpod params
func (o *ImagePullLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithArch adds the arch to the image pull libpod params
func (o *ImagePullLibpodParams) WithArch(arch *string) *ImagePullLibpodParams {
	o.SetArch(arch)
	return o
}

// SetArch adds the arch to the image pull libpod params
func (o *ImagePullLibpodParams) SetArch(arch *string) {
	o.Arch = arch
}

// WithOS adds the oS to the image pull libpod params
func (o *ImagePullLibpodParams) WithOS(oS *string) *ImagePullLibpodParams {
	o.SetOS(oS)
	return o
}

// SetOS adds the oS to the image pull libpod params
func (o *ImagePullLibpodParams) SetOS(oS *string) {
	o.OS = oS
}

// WithVariant adds the variant to the image pull libpod params
func (o *ImagePullLibpodParams) WithVariant(variant *string) *ImagePullLibpodParams {
	o.SetVariant(variant)
	return o
}

// SetVariant adds the variant to the image pull libpod params
func (o *ImagePullLibpodParams) SetVariant(variant *string) {
	o.Variant = variant
}

// WithXRegistryAuth adds the xRegistryAuth to the image pull libpod params
func (o *ImagePullLibpodParams) WithXRegistryAuth(xRegistryAuth *string) *ImagePullLibpodParams {
	o.SetXRegistryAuth(xRegistryAuth)
	return o
}

// SetXRegistryAuth adds the xRegistryAuth to the image pull libpod params
func (o *ImagePullLibpodParams) SetXRegistryAuth(xRegistryAuth *string) {
	o.XRegistryAuth = xRegistryAuth
}

// WithAllTags adds the allTags to the image pull libpod params
func (o *ImagePullLibpodParams) WithAllTags(allTags *bool) *ImagePullLibpodParams {
	o.SetAllTags(allTags)
	return o
}

// SetAllTags adds the allTags to the image pull libpod params
func (o *ImagePullLibpodParams) SetAllTags(allTags *bool) {
	o.AllTags = allTags
}

// WithCredentials adds the credentials to the image pull libpod params
func (o *ImagePullLibpodParams) WithCredentials(credentials *string) *ImagePullLibpodParams {
	o.SetCredentials(credentials)
	return o
}

// SetCredentials adds the credentials to the image pull libpod params
func (o *ImagePullLibpodParams) SetCredentials(credentials *string) {
	o.Credentials = credentials
}

// WithPolicy adds the policy to the image pull libpod params
func (o *ImagePullLibpodParams) WithPolicy(policy *string) *ImagePullLibpodParams {
	o.SetPolicy(policy)
	return o
}

// SetPolicy adds the policy to the image pull libpod params
func (o *ImagePullLibpodParams) SetPolicy(policy *string) {
	o.Policy = policy
}

// WithQuiet adds the quiet to the image pull libpod params
func (o *ImagePullLibpodParams) WithQuiet(quiet *bool) *ImagePullLibpodParams {
	o.SetQuiet(quiet)
	return o
}

// SetQuiet adds the quiet to the image pull libpod params
func (o *ImagePullLibpodParams) SetQuiet(quiet *bool) {
	o.Quiet = quiet
}

// WithReference adds the reference to the image pull libpod params
func (o *ImagePullLibpodParams) WithReference(reference *string) *ImagePullLibpodParams {
	o.SetReference(reference)
	return o
}

// SetReference adds the reference to the image pull libpod params
func (o *ImagePullLibpodParams) SetReference(reference *string) {
	o.Reference = reference
}

// WithTLSVerify adds the tLSVerify to the image pull libpod params
func (o *ImagePullLibpodParams) WithTLSVerify(tLSVerify *bool) *ImagePullLibpodParams {
	o.SetTLSVerify(tLSVerify)
	return o
}

// SetTLSVerify adds the tlsVerify to the image pull libpod params
func (o *ImagePullLibpodParams) SetTLSVerify(tLSVerify *bool) {
	o.TLSVerify = tLSVerify
}

// WriteToRequest writes these params to a swagger request
func (o *ImagePullLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Arch != nil {

		// query param Arch
		var qrArch string

		if o.Arch != nil {
			qrArch = *o.Arch
		}
		qArch := qrArch
		if qArch != "" {

			if err := r.SetQueryParam("Arch", qArch); err != nil {
				return err
			}
		}
	}

	if o.OS != nil {

		// query param OS
		var qrOS string

		if o.OS != nil {
			qrOS = *o.OS
		}
		qOS := qrOS
		if qOS != "" {

			if err := r.SetQueryParam("OS", qOS); err != nil {
				return err
			}
		}
	}

	if o.Variant != nil {

		// query param Variant
		var qrVariant string

		if o.Variant != nil {
			qrVariant = *o.Variant
		}
		qVariant := qrVariant
		if qVariant != "" {

			if err := r.SetQueryParam("Variant", qVariant); err != nil {
				return err
			}
		}
	}

	if o.XRegistryAuth != nil {

		// header param X-Registry-Auth
		if err := r.SetHeaderParam("X-Registry-Auth", *o.XRegistryAuth); err != nil {
			return err
		}
	}

	if o.AllTags != nil {

		// query param allTags
		var qrAllTags bool

		if o.AllTags != nil {
			qrAllTags = *o.AllTags
		}
		qAllTags := swag.FormatBool(qrAllTags)
		if qAllTags != "" {

			if err := r.SetQueryParam("allTags", qAllTags); err != nil {
				return err
			}
		}
	}

	if o.Credentials != nil {

		// query param credentials
		var qrCredentials string

		if o.Credentials != nil {
			qrCredentials = *o.Credentials
		}
		qCredentials := qrCredentials
		if qCredentials != "" {

			if err := r.SetQueryParam("credentials", qCredentials); err != nil {
				return err
			}
		}
	}

	if o.Policy != nil {

		// query param policy
		var qrPolicy string

		if o.Policy != nil {
			qrPolicy = *o.Policy
		}
		qPolicy := qrPolicy
		if qPolicy != "" {

			if err := r.SetQueryParam("policy", qPolicy); err != nil {
				return err
			}
		}
	}

	if o.Quiet != nil {

		// query param quiet
		var qrQuiet bool

		if o.Quiet != nil {
			qrQuiet = *o.Quiet
		}
		qQuiet := swag.FormatBool(qrQuiet)
		if qQuiet != "" {

			if err := r.SetQueryParam("quiet", qQuiet); err != nil {
				return err
			}
		}
	}

	if o.Reference != nil {

		// query param reference
		var qrReference string

		if o.Reference != nil {
			qrReference = *o.Reference
		}
		qReference := qrReference
		if qReference != "" {

			if err := r.SetQueryParam("reference", qReference); err != nil {
				return err
			}
		}
	}

	if o.TLSVerify != nil {

		// query param tlsVerify
		var qrTLSVerify bool

		if o.TLSVerify != nil {
			qrTLSVerify = *o.TLSVerify
		}
		qTLSVerify := swag.FormatBool(qrTLSVerify)
		if qTLSVerify != "" {

			if err := r.SetQueryParam("tlsVerify", qTLSVerify); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
