// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NetOptions NetOptions reflect the shared network options between
// pods and containers
//
// swagger:model NetOptions
type NetOptions struct {

	// add hosts
	AddHosts []string `json:"hostadd"`

	// aliases
	Aliases []string `json:"network_alias"`

	// DNS options
	DNSOptions []string `json:"dns_option"`

	// DNS search
	DNSSearch []string `json:"dns_search"`

	// DNS servers
	DNSServers []IP `json:"dns_server"`

	// NetworkOptions are additional options for each network
	NetworkOptions map[string][]string `json:"network_options,omitempty"`

	// networks
	Networks map[string]PerNetworkOptions `json:"networks,omitempty"`

	// no hosts
	NoHosts bool `json:"no_manage_hosts,omitempty"`

	// publish ports
	PublishPorts []*PortMapping `json:"portmappings"`

	// use image resolv conf
	UseImageResolvConf bool `json:"no_manage_resolv_conf,omitempty"`

	// netns
	Netns *Namespace `json:"netns,omitempty"`
}

// Validate validates this net options
func (m *NetOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDNSServers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetworks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePublishPorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetns(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetOptions) validateDNSServers(formats strfmt.Registry) error {
	if swag.IsZero(m.DNSServers) { // not required
		return nil
	}

	for i := 0; i < len(m.DNSServers); i++ {

		if err := m.DNSServers[i].Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dns_server" + "." + strconv.Itoa(i))
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("dns_server" + "." + strconv.Itoa(i))
			}
			return err
		}

	}

	return nil
}

func (m *NetOptions) validateNetworks(formats strfmt.Registry) error {
	if swag.IsZero(m.Networks) { // not required
		return nil
	}

	for k := range m.Networks {

		if err := validate.Required("networks"+"."+k, "body", m.Networks[k]); err != nil {
			return err
		}
		if val, ok := m.Networks[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("networks" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("networks" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *NetOptions) validatePublishPorts(formats strfmt.Registry) error {
	if swag.IsZero(m.PublishPorts) { // not required
		return nil
	}

	for i := 0; i < len(m.PublishPorts); i++ {
		if swag.IsZero(m.PublishPorts[i]) { // not required
			continue
		}

		if m.PublishPorts[i] != nil {
			if err := m.PublishPorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("portmappings" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("portmappings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NetOptions) validateNetns(formats strfmt.Registry) error {
	if swag.IsZero(m.Netns) { // not required
		return nil
	}

	if m.Netns != nil {
		if err := m.Netns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("netns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("netns")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this net options based on the context it is used
func (m *NetOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDNSServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetworks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePublishPorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetOptions) contextValidateDNSServers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DNSServers); i++ {

		if err := m.DNSServers[i].ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dns_server" + "." + strconv.Itoa(i))
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("dns_server" + "." + strconv.Itoa(i))
			}
			return err
		}

	}

	return nil
}

func (m *NetOptions) contextValidateNetworks(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Networks {

		if val, ok := m.Networks[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *NetOptions) contextValidatePublishPorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PublishPorts); i++ {

		if m.PublishPorts[i] != nil {
			if err := m.PublishPorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("portmappings" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("portmappings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NetOptions) contextValidateNetns(ctx context.Context, formats strfmt.Registry) error {

	if m.Netns != nil {
		if err := m.Netns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("netns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("netns")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NetOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NetOptions) UnmarshalBinary(b []byte) error {
	var res NetOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
