// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// ContainerHealthcheckLibpodReader is a Reader for the ContainerHealthcheckLibpod structure.
type ContainerHealthcheckLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerHealthcheckLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerHealthcheckLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerHealthcheckLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewContainerHealthcheckLibpodConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerHealthcheckLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerHealthcheckLibpodOK creates a ContainerHealthcheckLibpodOK with default headers values
func NewContainerHealthcheckLibpodOK() *ContainerHealthcheckLibpodOK {
	return &ContainerHealthcheckLibpodOK{}
}

/*
ContainerHealthcheckLibpodOK describes a response with status code 200, with default header values.

Healthcheck
*/
type ContainerHealthcheckLibpodOK struct {
	Payload *ContainerHealthcheckLibpodOKBody
}

// IsSuccess returns true when this container healthcheck libpod o k response has a 2xx status code
func (o *ContainerHealthcheckLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container healthcheck libpod o k response has a 3xx status code
func (o *ContainerHealthcheckLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container healthcheck libpod o k response has a 4xx status code
func (o *ContainerHealthcheckLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container healthcheck libpod o k response has a 5xx status code
func (o *ContainerHealthcheckLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container healthcheck libpod o k response a status code equal to that given
func (o *ContainerHealthcheckLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerHealthcheckLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/healthcheck][%d] containerHealthcheckLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerHealthcheckLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/healthcheck][%d] containerHealthcheckLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerHealthcheckLibpodOK) GetPayload() *ContainerHealthcheckLibpodOKBody {
	return o.Payload
}

func (o *ContainerHealthcheckLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerHealthcheckLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerHealthcheckLibpodNotFound creates a ContainerHealthcheckLibpodNotFound with default headers values
func NewContainerHealthcheckLibpodNotFound() *ContainerHealthcheckLibpodNotFound {
	return &ContainerHealthcheckLibpodNotFound{}
}

/*
ContainerHealthcheckLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerHealthcheckLibpodNotFound struct {
	Payload *ContainerHealthcheckLibpodNotFoundBody
}

// IsSuccess returns true when this container healthcheck libpod not found response has a 2xx status code
func (o *ContainerHealthcheckLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container healthcheck libpod not found response has a 3xx status code
func (o *ContainerHealthcheckLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container healthcheck libpod not found response has a 4xx status code
func (o *ContainerHealthcheckLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container healthcheck libpod not found response has a 5xx status code
func (o *ContainerHealthcheckLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container healthcheck libpod not found response a status code equal to that given
func (o *ContainerHealthcheckLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerHealthcheckLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/healthcheck][%d] containerHealthcheckLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerHealthcheckLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/healthcheck][%d] containerHealthcheckLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerHealthcheckLibpodNotFound) GetPayload() *ContainerHealthcheckLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerHealthcheckLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerHealthcheckLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerHealthcheckLibpodConflict creates a ContainerHealthcheckLibpodConflict with default headers values
func NewContainerHealthcheckLibpodConflict() *ContainerHealthcheckLibpodConflict {
	return &ContainerHealthcheckLibpodConflict{}
}

/*
ContainerHealthcheckLibpodConflict describes a response with status code 409, with default header values.

container has no healthcheck or is not running
*/
type ContainerHealthcheckLibpodConflict struct {
}

// IsSuccess returns true when this container healthcheck libpod conflict response has a 2xx status code
func (o *ContainerHealthcheckLibpodConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container healthcheck libpod conflict response has a 3xx status code
func (o *ContainerHealthcheckLibpodConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container healthcheck libpod conflict response has a 4xx status code
func (o *ContainerHealthcheckLibpodConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this container healthcheck libpod conflict response has a 5xx status code
func (o *ContainerHealthcheckLibpodConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this container healthcheck libpod conflict response a status code equal to that given
func (o *ContainerHealthcheckLibpodConflict) IsCode(code int) bool {
	return code == 409
}

func (o *ContainerHealthcheckLibpodConflict) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/healthcheck][%d] containerHealthcheckLibpodConflict ", 409)
}

func (o *ContainerHealthcheckLibpodConflict) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/healthcheck][%d] containerHealthcheckLibpodConflict ", 409)
}

func (o *ContainerHealthcheckLibpodConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerHealthcheckLibpodInternalServerError creates a ContainerHealthcheckLibpodInternalServerError with default headers values
func NewContainerHealthcheckLibpodInternalServerError() *ContainerHealthcheckLibpodInternalServerError {
	return &ContainerHealthcheckLibpodInternalServerError{}
}

/*
ContainerHealthcheckLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerHealthcheckLibpodInternalServerError struct {
	Payload *ContainerHealthcheckLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container healthcheck libpod internal server error response has a 2xx status code
func (o *ContainerHealthcheckLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container healthcheck libpod internal server error response has a 3xx status code
func (o *ContainerHealthcheckLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container healthcheck libpod internal server error response has a 4xx status code
func (o *ContainerHealthcheckLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container healthcheck libpod internal server error response has a 5xx status code
func (o *ContainerHealthcheckLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container healthcheck libpod internal server error response a status code equal to that given
func (o *ContainerHealthcheckLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerHealthcheckLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/healthcheck][%d] containerHealthcheckLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerHealthcheckLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/healthcheck][%d] containerHealthcheckLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerHealthcheckLibpodInternalServerError) GetPayload() *ContainerHealthcheckLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerHealthcheckLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerHealthcheckLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerHealthcheckLibpodInternalServerErrorBody container healthcheck libpod internal server error body
swagger:model ContainerHealthcheckLibpodInternalServerErrorBody
*/
type ContainerHealthcheckLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container healthcheck libpod internal server error body
func (o *ContainerHealthcheckLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container healthcheck libpod internal server error body based on context it is used
func (o *ContainerHealthcheckLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerHealthcheckLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerHealthcheckLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerHealthcheckLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerHealthcheckLibpodNotFoundBody container healthcheck libpod not found body
swagger:model ContainerHealthcheckLibpodNotFoundBody
*/
type ContainerHealthcheckLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container healthcheck libpod not found body
func (o *ContainerHealthcheckLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container healthcheck libpod not found body based on context it is used
func (o *ContainerHealthcheckLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerHealthcheckLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerHealthcheckLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerHealthcheckLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerHealthcheckLibpodOKBody container healthcheck libpod o k body
swagger:model ContainerHealthcheckLibpodOKBody
*/
type ContainerHealthcheckLibpodOKBody struct {

	// FailingStreak is the number of consecutive failed healthchecks
	FailingStreak int64 `json:"FailingStreak,omitempty"`

	// Log describes healthcheck attempts and results
	Log []*models.HealthCheckLog `json:"Log"`

	// Status healthy or unhealthy
	Status string `json:"Status,omitempty"`
}

// Validate validates this container healthcheck libpod o k body
func (o *ContainerHealthcheckLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLog(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ContainerHealthcheckLibpodOKBody) validateLog(formats strfmt.Registry) error {
	if swag.IsZero(o.Log) { // not required
		return nil
	}

	for i := 0; i < len(o.Log); i++ {
		if swag.IsZero(o.Log[i]) { // not required
			continue
		}

		if o.Log[i] != nil {
			if err := o.Log[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("containerHealthcheckLibpodOK" + "." + "Log" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("containerHealthcheckLibpodOK" + "." + "Log" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container healthcheck libpod o k body based on the context it is used
func (o *ContainerHealthcheckLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ContainerHealthcheckLibpodOKBody) contextValidateLog(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Log); i++ {

		if o.Log[i] != nil {
			if err := o.Log[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("containerHealthcheckLibpodOK" + "." + "Log" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("containerHealthcheckLibpodOK" + "." + "Log" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ContainerHealthcheckLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerHealthcheckLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res ContainerHealthcheckLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
