// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerListLibpodParams creates a new ContainerListLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerListLibpodParams() *ContainerListLibpodParams {
	return &ContainerListLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerListLibpodParamsWithTimeout creates a new ContainerListLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerListLibpodParamsWithTimeout(timeout time.Duration) *ContainerListLibpodParams {
	return &ContainerListLibpodParams{
		timeout: timeout,
	}
}

// NewContainerListLibpodParamsWithContext creates a new ContainerListLibpodParams object
// with the ability to set a context for a request.
func NewContainerListLibpodParamsWithContext(ctx context.Context) *ContainerListLibpodParams {
	return &ContainerListLibpodParams{
		Context: ctx,
	}
}

// NewContainerListLibpodParamsWithHTTPClient creates a new ContainerListLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerListLibpodParamsWithHTTPClient(client *http.Client) *ContainerListLibpodParams {
	return &ContainerListLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerListLibpodParams contains all the parameters to send to the API endpoint

	for the container list libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerListLibpodParams struct {

	/* All.

	   Return all containers. By default, only running containers are shown
	*/
	All *bool

	/* Filters.

	     A JSON encoded value of the filters (a `map[string][]string`) to process on the containers list. Available filters:
	- `ancestor`=(`<image-name>[:<tag>]`, `<image id>`, or `<image@digest>`)
	- `before`=(`<container id>` or `<container name>`)
	- `expose`=(`<port>[/<proto>]` or `<startport-endport>/[<proto>]`)
	- `exited=<int>` containers with exit code of `<int>`
	- `health`=(`starting`, `healthy`, `unhealthy` or `none`)
	- `id=<ID>` a container's ID
	- `is-task`=(`true` or `false`)
	- `label`=(`key` or `"key=value"`) of an container label
	- `name=<name>` a container's name
	- `network`=(`<network id>` or `<network name>`)
	- `pod`=(`<pod id>` or `<pod name>`)
	- `publish`=(`<port>[/<proto>]` or `<startport-endport>/[<proto>]`)
	- `since`=(`<container id>` or `<container name>`)
	- `status`=(`created`, `restarting`, `running`, `removing`, `paused`, `exited` or `dead`)
	- `volume`=(`<volume name>` or `<mount point destination>`)

	*/
	Filters *string

	/* Limit.

	   Return this number of most recently created containers, including non-running ones.
	*/
	Limit *int64

	/* Pod.

	   Ignored. Previously included details on pod name and ID that are currently included by default.
	*/
	Pod *bool

	/* Size.

	   Return the size of container as fields SizeRw and SizeRootFs.
	*/
	Size *bool

	/* Sync.

	   Sync container state with OCI runtime
	*/
	Sync *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container list libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerListLibpodParams) WithDefaults() *ContainerListLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container list libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerListLibpodParams) SetDefaults() {
	var (
		allDefault = bool(false)

		podDefault = bool(false)

		sizeDefault = bool(false)

		syncDefault = bool(false)
	)

	val := ContainerListLibpodParams{
		All:  &allDefault,
		Pod:  &podDefault,
		Size: &sizeDefault,
		Sync: &syncDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the container list libpod params
func (o *ContainerListLibpodParams) WithTimeout(timeout time.Duration) *ContainerListLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container list libpod params
func (o *ContainerListLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container list libpod params
func (o *ContainerListLibpodParams) WithContext(ctx context.Context) *ContainerListLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container list libpod params
func (o *ContainerListLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container list libpod params
func (o *ContainerListLibpodParams) WithHTTPClient(client *http.Client) *ContainerListLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container list libpod params
func (o *ContainerListLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAll adds the all to the container list libpod params
func (o *ContainerListLibpodParams) WithAll(all *bool) *ContainerListLibpodParams {
	o.SetAll(all)
	return o
}

// SetAll adds the all to the container list libpod params
func (o *ContainerListLibpodParams) SetAll(all *bool) {
	o.All = all
}

// WithFilters adds the filters to the container list libpod params
func (o *ContainerListLibpodParams) WithFilters(filters *string) *ContainerListLibpodParams {
	o.SetFilters(filters)
	return o
}

// SetFilters adds the filters to the container list libpod params
func (o *ContainerListLibpodParams) SetFilters(filters *string) {
	o.Filters = filters
}

// WithLimit adds the limit to the container list libpod params
func (o *ContainerListLibpodParams) WithLimit(limit *int64) *ContainerListLibpodParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the container list libpod params
func (o *ContainerListLibpodParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithPod adds the pod to the container list libpod params
func (o *ContainerListLibpodParams) WithPod(pod *bool) *ContainerListLibpodParams {
	o.SetPod(pod)
	return o
}

// SetPod adds the pod to the container list libpod params
func (o *ContainerListLibpodParams) SetPod(pod *bool) {
	o.Pod = pod
}

// WithSize adds the size to the container list libpod params
func (o *ContainerListLibpodParams) WithSize(size *bool) *ContainerListLibpodParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the container list libpod params
func (o *ContainerListLibpodParams) SetSize(size *bool) {
	o.Size = size
}

// WithSync adds the sync to the container list libpod params
func (o *ContainerListLibpodParams) WithSync(sync *bool) *ContainerListLibpodParams {
	o.SetSync(sync)
	return o
}

// SetSync adds the sync to the container list libpod params
func (o *ContainerListLibpodParams) SetSync(sync *bool) {
	o.Sync = sync
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerListLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.All != nil {

		// query param all
		var qrAll bool

		if o.All != nil {
			qrAll = *o.All
		}
		qAll := swag.FormatBool(qrAll)
		if qAll != "" {

			if err := r.SetQueryParam("all", qAll); err != nil {
				return err
			}
		}
	}

	if o.Filters != nil {

		// query param filters
		var qrFilters string

		if o.Filters != nil {
			qrFilters = *o.Filters
		}
		qFilters := qrFilters
		if qFilters != "" {

			if err := r.SetQueryParam("filters", qFilters); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Pod != nil {

		// query param pod
		var qrPod bool

		if o.Pod != nil {
			qrPod = *o.Pod
		}
		qPod := swag.FormatBool(qrPod)
		if qPod != "" {

			if err := r.SetQueryParam("pod", qPod); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize bool

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatBool(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.Sync != nil {

		// query param sync
		var qrSync bool

		if o.Sync != nil {
			qrSync = *o.Sync
		}
		qSync := swag.FormatBool(qrSync)
		if qSync != "" {

			if err := r.SetQueryParam("sync", qSync); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
