// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerLogsReader is a Reader for the ContainerLogs structure.
type ContainerLogsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerLogsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerLogsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerLogsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerLogsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerLogsOK creates a ContainerLogsOK with default headers values
func NewContainerLogsOK() *ContainerLogsOK {
	return &ContainerLogsOK{}
}

/*
ContainerLogsOK describes a response with status code 200, with default header values.

logs returned as a stream in response body.
*/
type ContainerLogsOK struct {
}

// IsSuccess returns true when this container logs o k response has a 2xx status code
func (o *ContainerLogsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container logs o k response has a 3xx status code
func (o *ContainerLogsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container logs o k response has a 4xx status code
func (o *ContainerLogsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container logs o k response has a 5xx status code
func (o *ContainerLogsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container logs o k response a status code equal to that given
func (o *ContainerLogsOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerLogsOK) Error() string {
	return fmt.Sprintf("[GET /containers/{name}/logs][%d] containerLogsOK ", 200)
}

func (o *ContainerLogsOK) String() string {
	return fmt.Sprintf("[GET /containers/{name}/logs][%d] containerLogsOK ", 200)
}

func (o *ContainerLogsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerLogsNotFound creates a ContainerLogsNotFound with default headers values
func NewContainerLogsNotFound() *ContainerLogsNotFound {
	return &ContainerLogsNotFound{}
}

/*
ContainerLogsNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerLogsNotFound struct {
	Payload *ContainerLogsNotFoundBody
}

// IsSuccess returns true when this container logs not found response has a 2xx status code
func (o *ContainerLogsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container logs not found response has a 3xx status code
func (o *ContainerLogsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container logs not found response has a 4xx status code
func (o *ContainerLogsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container logs not found response has a 5xx status code
func (o *ContainerLogsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container logs not found response a status code equal to that given
func (o *ContainerLogsNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerLogsNotFound) Error() string {
	return fmt.Sprintf("[GET /containers/{name}/logs][%d] containerLogsNotFound  %+v", 404, o.Payload)
}

func (o *ContainerLogsNotFound) String() string {
	return fmt.Sprintf("[GET /containers/{name}/logs][%d] containerLogsNotFound  %+v", 404, o.Payload)
}

func (o *ContainerLogsNotFound) GetPayload() *ContainerLogsNotFoundBody {
	return o.Payload
}

func (o *ContainerLogsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerLogsNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerLogsInternalServerError creates a ContainerLogsInternalServerError with default headers values
func NewContainerLogsInternalServerError() *ContainerLogsInternalServerError {
	return &ContainerLogsInternalServerError{}
}

/*
ContainerLogsInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerLogsInternalServerError struct {
	Payload *ContainerLogsInternalServerErrorBody
}

// IsSuccess returns true when this container logs internal server error response has a 2xx status code
func (o *ContainerLogsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container logs internal server error response has a 3xx status code
func (o *ContainerLogsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container logs internal server error response has a 4xx status code
func (o *ContainerLogsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container logs internal server error response has a 5xx status code
func (o *ContainerLogsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container logs internal server error response a status code equal to that given
func (o *ContainerLogsInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerLogsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /containers/{name}/logs][%d] containerLogsInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerLogsInternalServerError) String() string {
	return fmt.Sprintf("[GET /containers/{name}/logs][%d] containerLogsInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerLogsInternalServerError) GetPayload() *ContainerLogsInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerLogsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerLogsInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerLogsInternalServerErrorBody container logs internal server error body
swagger:model ContainerLogsInternalServerErrorBody
*/
type ContainerLogsInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container logs internal server error body
func (o *ContainerLogsInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container logs internal server error body based on context it is used
func (o *ContainerLogsInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerLogsInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerLogsInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerLogsInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerLogsNotFoundBody container logs not found body
swagger:model ContainerLogsNotFoundBody
*/
type ContainerLogsNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container logs not found body
func (o *ContainerLogsNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container logs not found body based on context it is used
func (o *ContainerLogsNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerLogsNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerLogsNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerLogsNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
