// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImageGetLibpodParams creates a new ImageGetLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImageGetLibpodParams() *ImageGetLibpodParams {
	return &ImageGetLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImageGetLibpodParamsWithTimeout creates a new ImageGetLibpodParams object
// with the ability to set a timeout on a request.
func NewImageGetLibpodParamsWithTimeout(timeout time.Duration) *ImageGetLibpodParams {
	return &ImageGetLibpodParams{
		timeout: timeout,
	}
}

// NewImageGetLibpodParamsWithContext creates a new ImageGetLibpodParams object
// with the ability to set a context for a request.
func NewImageGetLibpodParamsWithContext(ctx context.Context) *ImageGetLibpodParams {
	return &ImageGetLibpodParams{
		Context: ctx,
	}
}

// NewImageGetLibpodParamsWithHTTPClient creates a new ImageGetLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewImageGetLibpodParamsWithHTTPClient(client *http.Client) *ImageGetLibpodParams {
	return &ImageGetLibpodParams{
		HTTPClient: client,
	}
}

/*
ImageGetLibpodParams contains all the parameters to send to the API endpoint

	for the image get libpod operation.

	Typically these are written to a http.Request.
*/
type ImageGetLibpodParams struct {

	/* Compress.

	   use compression on image
	*/
	Compress *bool

	/* Format.

	   format for exported image
	*/
	Format *string

	/* Name.

	   the name or ID of the container
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image get libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageGetLibpodParams) WithDefaults() *ImageGetLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image get libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageGetLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the image get libpod params
func (o *ImageGetLibpodParams) WithTimeout(timeout time.Duration) *ImageGetLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image get libpod params
func (o *ImageGetLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image get libpod params
func (o *ImageGetLibpodParams) WithContext(ctx context.Context) *ImageGetLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image get libpod params
func (o *ImageGetLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image get libpod params
func (o *ImageGetLibpodParams) WithHTTPClient(client *http.Client) *ImageGetLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image get libpod params
func (o *ImageGetLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCompress adds the compress to the image get libpod params
func (o *ImageGetLibpodParams) WithCompress(compress *bool) *ImageGetLibpodParams {
	o.SetCompress(compress)
	return o
}

// SetCompress adds the compress to the image get libpod params
func (o *ImageGetLibpodParams) SetCompress(compress *bool) {
	o.Compress = compress
}

// WithFormat adds the format to the image get libpod params
func (o *ImageGetLibpodParams) WithFormat(format *string) *ImageGetLibpodParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the image get libpod params
func (o *ImageGetLibpodParams) SetFormat(format *string) {
	o.Format = format
}

// WithName adds the name to the image get libpod params
func (o *ImageGetLibpodParams) WithName(name string) *ImageGetLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the image get libpod params
func (o *ImageGetLibpodParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *ImageGetLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Compress != nil {

		// query param compress
		var qrCompress bool

		if o.Compress != nil {
			qrCompress = *o.Compress
		}
		qCompress := swag.FormatBool(qrCompress)
		if qCompress != "" {

			if err := r.SetQueryParam("compress", qCompress); err != nil {
				return err
			}
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
