// Code generated by go-swagger; DO NOT EDIT.

package networks_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// NetworkListReader is a Reader for the NetworkList structure.
type NetworkListReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkListReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkListOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewNetworkListInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewNetworkListOK creates a NetworkListOK with default headers values
func NewNetworkListOK() *NetworkListOK {
	return &NetworkListOK{}
}

/*
NetworkListOK describes a response with status code 200, with default header values.

Network list
*/
type NetworkListOK struct {
	Payload []*models.NetworkResource
}

// IsSuccess returns true when this network list o k response has a 2xx status code
func (o *NetworkListOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network list o k response has a 3xx status code
func (o *NetworkListOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network list o k response has a 4xx status code
func (o *NetworkListOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network list o k response has a 5xx status code
func (o *NetworkListOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network list o k response a status code equal to that given
func (o *NetworkListOK) IsCode(code int) bool {
	return code == 200
}

func (o *NetworkListOK) Error() string {
	return fmt.Sprintf("[GET /networks][%d] networkListOK  %+v", 200, o.Payload)
}

func (o *NetworkListOK) String() string {
	return fmt.Sprintf("[GET /networks][%d] networkListOK  %+v", 200, o.Payload)
}

func (o *NetworkListOK) GetPayload() []*models.NetworkResource {
	return o.Payload
}

func (o *NetworkListOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkListInternalServerError creates a NetworkListInternalServerError with default headers values
func NewNetworkListInternalServerError() *NetworkListInternalServerError {
	return &NetworkListInternalServerError{}
}

/*
NetworkListInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type NetworkListInternalServerError struct {
	Payload *NetworkListInternalServerErrorBody
}

// IsSuccess returns true when this network list internal server error response has a 2xx status code
func (o *NetworkListInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network list internal server error response has a 3xx status code
func (o *NetworkListInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network list internal server error response has a 4xx status code
func (o *NetworkListInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this network list internal server error response has a 5xx status code
func (o *NetworkListInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this network list internal server error response a status code equal to that given
func (o *NetworkListInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *NetworkListInternalServerError) Error() string {
	return fmt.Sprintf("[GET /networks][%d] networkListInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkListInternalServerError) String() string {
	return fmt.Sprintf("[GET /networks][%d] networkListInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkListInternalServerError) GetPayload() *NetworkListInternalServerErrorBody {
	return o.Payload
}

func (o *NetworkListInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkListInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkListInternalServerErrorBody network list internal server error body
swagger:model NetworkListInternalServerErrorBody
*/
type NetworkListInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network list internal server error body
func (o *NetworkListInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network list internal server error body based on context it is used
func (o *NetworkListInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkListInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkListInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res NetworkListInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
