// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageTreeLibpodReader is a Reader for the ImageTreeLibpod structure.
type ImageTreeLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageTreeLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageTreeLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewImageTreeLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageTreeLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageTreeLibpodOK creates a ImageTreeLibpodOK with default headers values
func NewImageTreeLibpodOK() *ImageTreeLibpodOK {
	return &ImageTreeLibpodOK{}
}

/*
ImageTreeLibpodOK describes a response with status code 200, with default header values.

Tree response
*/
type ImageTreeLibpodOK struct {
	Payload *ImageTreeLibpodOKBody
}

// IsSuccess returns true when this image tree libpod o k response has a 2xx status code
func (o *ImageTreeLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image tree libpod o k response has a 3xx status code
func (o *ImageTreeLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image tree libpod o k response has a 4xx status code
func (o *ImageTreeLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image tree libpod o k response has a 5xx status code
func (o *ImageTreeLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image tree libpod o k response a status code equal to that given
func (o *ImageTreeLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageTreeLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/tree][%d] imageTreeLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageTreeLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/tree][%d] imageTreeLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageTreeLibpodOK) GetPayload() *ImageTreeLibpodOKBody {
	return o.Payload
}

func (o *ImageTreeLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageTreeLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageTreeLibpodNotFound creates a ImageTreeLibpodNotFound with default headers values
func NewImageTreeLibpodNotFound() *ImageTreeLibpodNotFound {
	return &ImageTreeLibpodNotFound{}
}

/*
ImageTreeLibpodNotFound describes a response with status code 404, with default header values.

No such image
*/
type ImageTreeLibpodNotFound struct {
	Payload *ImageTreeLibpodNotFoundBody
}

// IsSuccess returns true when this image tree libpod not found response has a 2xx status code
func (o *ImageTreeLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image tree libpod not found response has a 3xx status code
func (o *ImageTreeLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image tree libpod not found response has a 4xx status code
func (o *ImageTreeLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this image tree libpod not found response has a 5xx status code
func (o *ImageTreeLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this image tree libpod not found response a status code equal to that given
func (o *ImageTreeLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ImageTreeLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/tree][%d] imageTreeLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageTreeLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/tree][%d] imageTreeLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageTreeLibpodNotFound) GetPayload() *ImageTreeLibpodNotFoundBody {
	return o.Payload
}

func (o *ImageTreeLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageTreeLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageTreeLibpodInternalServerError creates a ImageTreeLibpodInternalServerError with default headers values
func NewImageTreeLibpodInternalServerError() *ImageTreeLibpodInternalServerError {
	return &ImageTreeLibpodInternalServerError{}
}

/*
ImageTreeLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageTreeLibpodInternalServerError struct {
	Payload *ImageTreeLibpodInternalServerErrorBody
}

// IsSuccess returns true when this image tree libpod internal server error response has a 2xx status code
func (o *ImageTreeLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image tree libpod internal server error response has a 3xx status code
func (o *ImageTreeLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image tree libpod internal server error response has a 4xx status code
func (o *ImageTreeLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image tree libpod internal server error response has a 5xx status code
func (o *ImageTreeLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image tree libpod internal server error response a status code equal to that given
func (o *ImageTreeLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageTreeLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/tree][%d] imageTreeLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageTreeLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/tree][%d] imageTreeLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageTreeLibpodInternalServerError) GetPayload() *ImageTreeLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ImageTreeLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageTreeLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageTreeLibpodInternalServerErrorBody image tree libpod internal server error body
swagger:model ImageTreeLibpodInternalServerErrorBody
*/
type ImageTreeLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image tree libpod internal server error body
func (o *ImageTreeLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image tree libpod internal server error body based on context it is used
func (o *ImageTreeLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageTreeLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageTreeLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageTreeLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageTreeLibpodNotFoundBody image tree libpod not found body
swagger:model ImageTreeLibpodNotFoundBody
*/
type ImageTreeLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image tree libpod not found body
func (o *ImageTreeLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image tree libpod not found body based on context it is used
func (o *ImageTreeLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageTreeLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageTreeLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ImageTreeLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageTreeLibpodOKBody image tree libpod o k body
swagger:model ImageTreeLibpodOKBody
*/
type ImageTreeLibpodOKBody struct {

	// tree
	Tree string `json:"Tree,omitempty"`
}

// Validate validates this image tree libpod o k body
func (o *ImageTreeLibpodOKBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image tree libpod o k body based on context it is used
func (o *ImageTreeLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageTreeLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageTreeLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res ImageTreeLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
