// Code generated by go-swagger; DO NOT EDIT.

package networks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// NetworkPruneLibpodReader is a Reader for the NetworkPruneLibpod structure.
type NetworkPruneLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkPruneLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkPruneLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewNetworkPruneLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewNetworkPruneLibpodOK creates a NetworkPruneLibpodOK with default headers values
func NewNetworkPruneLibpodOK() *NetworkPruneLibpodOK {
	return &NetworkPruneLibpodOK{}
}

/*
NetworkPruneLibpodOK describes a response with status code 200, with default header values.

Network prune
*/
type NetworkPruneLibpodOK struct {
	Payload []*models.NetworkPruneReport
}

// IsSuccess returns true when this network prune libpod o k response has a 2xx status code
func (o *NetworkPruneLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network prune libpod o k response has a 3xx status code
func (o *NetworkPruneLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network prune libpod o k response has a 4xx status code
func (o *NetworkPruneLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network prune libpod o k response has a 5xx status code
func (o *NetworkPruneLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network prune libpod o k response a status code equal to that given
func (o *NetworkPruneLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *NetworkPruneLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/networks/prune][%d] networkPruneLibpodOK  %+v", 200, o.Payload)
}

func (o *NetworkPruneLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/networks/prune][%d] networkPruneLibpodOK  %+v", 200, o.Payload)
}

func (o *NetworkPruneLibpodOK) GetPayload() []*models.NetworkPruneReport {
	return o.Payload
}

func (o *NetworkPruneLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkPruneLibpodInternalServerError creates a NetworkPruneLibpodInternalServerError with default headers values
func NewNetworkPruneLibpodInternalServerError() *NetworkPruneLibpodInternalServerError {
	return &NetworkPruneLibpodInternalServerError{}
}

/*
NetworkPruneLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type NetworkPruneLibpodInternalServerError struct {
	Payload *NetworkPruneLibpodInternalServerErrorBody
}

// IsSuccess returns true when this network prune libpod internal server error response has a 2xx status code
func (o *NetworkPruneLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network prune libpod internal server error response has a 3xx status code
func (o *NetworkPruneLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network prune libpod internal server error response has a 4xx status code
func (o *NetworkPruneLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this network prune libpod internal server error response has a 5xx status code
func (o *NetworkPruneLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this network prune libpod internal server error response a status code equal to that given
func (o *NetworkPruneLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *NetworkPruneLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/networks/prune][%d] networkPruneLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkPruneLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/networks/prune][%d] networkPruneLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkPruneLibpodInternalServerError) GetPayload() *NetworkPruneLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *NetworkPruneLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkPruneLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkPruneLibpodInternalServerErrorBody network prune libpod internal server error body
swagger:model NetworkPruneLibpodInternalServerErrorBody
*/
type NetworkPruneLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network prune libpod internal server error body
func (o *NetworkPruneLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network prune libpod internal server error body based on context it is used
func (o *NetworkPruneLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkPruneLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkPruneLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res NetworkPruneLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
